/* Video Panel */
SDL_Surface *screen;
int screen_width = 640;
int screen_height = 480;
int game_width = 320;
int game_height = 240;
int fullscreen_mode = 0;
double camera_x = 0;
double camera_y = 0;
double camera_z = 0;
double camera_dx = 0;
double camera_dy = 0;
double camera_dz = 0;

/* Get sizes */
int wsvideo_width()
{
	return game_width;
}
int wsvideo_height()
{
	return game_height;
}

/* Sets window/fullscreen */
void wsvideo_mode(int new_mode)
{
	/* Set value */
	fullscreen_mode = new_mode;
}

/* Sets the resolution of the engine */
void wsvideo_resolution(int sw,int sh,int gw,int gh)
{
	/* Set values */
	screen_width = sw;
	screen_height = sh;
	game_width = gw;
	game_height = gh;
}

/* Starts the video system */
void wsvideo_init()
{
	/* Initialize SDL */
	if(SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK) == -1)
	{
		wserror_show("Could not start SDL.");
		return;
	}
	/* Set OpenGL properties */
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER,1);
	/* Set the video mode */
	if(fullscreen_mode)
		screen = SDL_SetVideoMode(screen_width,screen_height,0,SDL_OPENGL|SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN);
	else
		screen = SDL_SetVideoMode(screen_width,screen_height,0,SDL_OPENGL|SDL_HWSURFACE|SDL_DOUBLEBUF);
	if(!screen)
	{
		wserror_show("Could not set video mode.");
		return;
	}
	/* Prepare OpenGL */
	glClearColor(0,0,0,0);
	/* Finished */
	wslog_string("[VIDEO] Video systems are go.\n");
	/* Title the window if able */
	if(weaponsoul_window_title)
		SDL_WM_SetCaption(weaponsoul_window_title,"weaponsoul");
	else
		SDL_WM_SetCaption("WeaponSoul Engine","weaponsoul");
}

/* Prepare to draw 2D graphics */
void wsvideo_2d_begin()
{
	/* Set viewport */
	glViewport(0,0,screen_width,screen_height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0,game_width,game_height,0,-1.0,1.0);
	/* Enter model view */
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glDisable(GL_DEPTH_TEST); /* Not needed for 2D */
	glEnable(GL_TEXTURE_2D); /* Sprites */
	glEnable(GL_BLEND); /* Trans */
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE);
}

/* End 2d */
void wsvideo_2d_end()
{
	/* Flush all commands */
	glFlush();
	glDisable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_DEPTH_TEST); /* Needed for 3D */
}

/* Prepare to draw 3D graphics */
void wsvideo_3d_begin()
{
	/* Set viewport */
	glViewport(0,0,screen_width,screen_height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-128,128,-128,128,128*1.5,128*20);
	/* Enter model view */
	glMatrixMode(GL_MODELVIEW);
	glEnable(GL_TEXTURE_2D); /* Texture */
	glEnable(GL_BLEND); /* Trans */
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE);
}

/* End 2d */
void wsvideo_3d_end()
{
	/* Flush all commands */
	glFlush();
	glDisable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
}

/* Renders the current frame */
void wsvideo_main()
{
	unsigned int i;
	/* Erase the old picture */
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	/* Copy camera */
	wscamera_draw_copy();
	/* Prepare to draw 3D graphics */
	wsvideo_3d_begin();
	/* End 3d */
	wsvideo_3d_end();
	/* Prepare to draw 2D graphics */
	wsvideo_2d_begin();
	/* Draw 2D */
	if(mode_2d[current_mode])
		mode_2d[current_mode]();
	/* Draw global 2D */
	for(i = 0;i < num_modes;i++)
	{
		/* Is global? */
		if(mode_global[i])
		{
			/* Has drawing? */
			if(mode_2d[i])
				mode_2d[i]();
		}
	}
	/* End 2D graphics */
	wsvideo_2d_end();
	/* Swap the buffers to show the finished picture */
	SDL_GL_SwapBuffers();
}

/* Ends the video system */
void wsvideo_exit()
{
	/* End SDL */
	SDL_Quit();
	/* Announce */
	wslog_string("[VIDEO] Video systems shut down.\n");
}

/* Changes the global camera positon */
void wscamera_move(double x,double y,double z)
{
	/* Set */
	camera_x = x;
	camera_y = y;
	camera_z = z;
}

/* Gets the camera X position */
double wscamera_x()
{
	return camera_x;
}

/* Gets the camera Y position */
double wscamera_y()
{
	return camera_y;
}

/* Gets the camera Z position */
double wscamera_z()
{
	return camera_z;
}

/* Copies the camera to drawing position */
void wscamera_draw_copy()
{
	/* Copy */
	camera_dx = camera_x;
	camera_dy = camera_y;
	camera_dz = camera_z;
}

/* Gets the drawing x position */
double wscamera_draw_x()
{
	return camera_dx;
}

/* Gets the drawing y position */
double wscamera_draw_y()
{
	return camera_dy;
}

/* Gets the drawing z position */
double wscamera_draw_z()
{
	return camera_dz;
}
