#ifndef WSTILE_H
#define WSTILE_H

/* Tile values */
#define NULL_TILE 0

/* Types */
typedef entity_data *tilemap;

/* Entity skills */
typedef struct
{
	image set; /* Tileset image to use */
	int width,height; /* Dimensions of the tilemap */
}tilemap_header;

/* Internal use */
extern void wstile_init();

/*
	Creates a new tilemap with the tileset given.
	Width and Height are measured in tiles.
	A reference to the object is returned.
	It is given the default action used for tilemaps.
*/
extern void wstile_create(image tileset,int width,int height);

/*
	Draws the tilemap's current state (including position).
*/
extern void wstile_draw(tilemap who);

/*
	Changes a tile inside the tilemap at (x,y).
*/
extern void wstile_set(tilemap who,int x,int y,unsigned char tile);

/*
	Sets a collision value for a particular tile
*/
extern void wstile_collision_set(tilemap who,int tile,unsigned char value);

/*
	If a non-zero value is passed, all tilesets also highlight their collision hulls
	If zero is passed, tiles are drawn normally
*/
extern void wstile_show_hull(int val);

/*
	Returns the collision code for a tile space on the tilemap.
	Usually this just returns whether or not you can pass over the tiles.
*/
extern int wstile_collision_get(tilemap who,int x,int y);

#endif

