#ifndef WSTEXT_H
#define WSTEXT_H

/* Tab width */
#define TAB_WIDTH 8

/*
	Sets the font of the following text to be drawn.

	Applies for all text until this function is used again.
*/
extern void wstext_font(image what);

/*
	Draws a null-terminated string at (x,y).

	A font must be set from before. If a font was never set,
	an error occurs.
*/
extern void wstext_draw(char *what,int x,int y);

/*
	Behaves just like wsimage_alpha only it works for text
	which is made up of multiple images.
*/
extern void wstext_alpha(double new_alpha);

/*
	Behaves just like wsimage_scale only it can work for text.
*/
extern void wstext_scale(double new_sx,double new_sy);

/*
	Behaves just like wstext_draw, but draws a number instead.
*/
extern void wstext_draw_num(int what,int x,int y);

/*
	Behaves just like wstext_draw, but draws a real number instead.
*/
extern void wstext_draw_real(double what,int x,int y);

#endif
