/*
	WeaponSoul Text System
	written by WolfCoder (2009)
*/

/* Includes */
#include "weaponsoul.h"
#include <memory.h>

/* Globals */
image current_font; /* Current font to draw in */
int font_loaded = 0; /* Is there a current font? */
double text_alpha = 1; /* Alpha value of text */
double tsx = 1,tsy = 1; /* Text scale */

/* Set the font */
void wstext_font(image what)
{
	/* Set values */
	current_font = what;
	font_loaded = 1;
}

/* Set the transparency */
void wstext_alpha(double new_alpha)
{
	text_alpha = new_alpha;
}

/* Set scaling */
void wstext_scale(double new_sx,double new_sy)
{
	tsx = new_sx;
	tsy = new_sy;
}

/* Draw the font */
void wstext_draw(char *what,int x,int y)
{
	int cx,cy; /* Cursor position */
	int cn; /* Source character */
	int ct; /* Tab counter */
	/* Is there a font loaded? */
	if(!font_loaded)
	{
		wserror_show("Attempt to draw text without a font set first.");
		return;
	}
	/* Place the cursor */
	cx = x;
	cy = y;
	cn = 0;
	ct = TAB_WIDTH;
	/* Draw until a zero is reached */
	while(1)
	{
		/* Finish */
		if(what[cn] == 0)
			break;
		/* Return character */
		if(what[cn] == '\n')
		{
			/* Reset the left guide, and move down by character height */
			cx = x;
			if(tsy != 1)
				cy += (int)(wsimage_height(current_font)*tsy);
			else
				cy += wsimage_height(current_font);
			ct = TAB_WIDTH; /* Reset tabs */
		}
		/* Tab character */
		if(what[cn] == '\t')
		{
			/* Jump tab counter to the right */
			if(tsx != 1)
				cx += (int)(ct*wsimage_width(current_font)*tsx);
			else
				cx += ct*wsimage_width(current_font);
			ct = TAB_WIDTH; /* Reset tabs */
		}
		/* Visible character */
		if(what[cn] >= 32 && what[cn] < 32+96)
		{
			/* Print */
			wsimage_frame(what[cn]-32);
			if(text_alpha < 1)
				wsimage_alpha(text_alpha);
			if(tsx != 1 || tsy != 1)
				wsimage_scale(tsx,tsy);
			wsimage_draw(current_font,cx,cy);
			if(tsx != 1)
				cx += (int)(wsimage_width(current_font)*tsx);
			else
				cx += wsimage_width(current_font);
			ct--; /* Reduce tab once */
			if(ct <= 0)
				ct = TAB_WIDTH; /* Reset tabs */
		}
		/* Next */
		cn++;
	}
	/* Reset text properties */
	text_alpha = 1;
	tsx = 1;
	tsy = 1;
}

/* Draws a number instead */
void wstext_draw_num(int what,int x,int y)
{
	char num_buff[MAX_NAME];
	/* Clear num buff */
	memset(num_buff,0,MAX_NAME);
	/* Process num buff */
#ifndef WIN32
	sprintf(num_buff,"%d",what);
#endif
#ifdef WIN32
	sprintf_s(num_buff,MAX_NAME,"%d",what);
#endif
	/* And finally, draw */
	wstext_draw(num_buff,x,y);
}

/* Draws a floating point instead */
void wstext_draw_real(double what,int x,int y)
{
	char num_buff[MAX_NAME];
	/* Clear num buff */
	memset(num_buff,0,MAX_NAME);
	/* Process num buff */
#ifndef WIN32
	sprintf(num_buff,"%f",what);
#endif
#ifdef WIN32
	sprintf_s(num_buff,MAX_NAME,"%f",what);
#endif
	/* And finally, draw */
	wstext_draw(num_buff,x,y);
}
