#ifndef WSSPRITE_H
#define WSSPRITE_H

/* Directions */
#define FACE_UP 0
#define FACE_DOWN 1
#define FACE_RIGHT 2
#define FACE_LEFT 3

/* Types */
typedef entity_data *sprite;

/*
	Create a new sprite.

	Follows rules of actions.
*/
extern void wssprite_create(action (*beh)(),double x,double y,double z,image body);

/*
	Returns the number of current entities
	that are sprites.
*/
extern int wssprite_num();

/*
	Draws all sprites who's type matches target

	the type value is used to layer sprites in order
	for proper display
*/
extern void wssprite_draw(int target);

/*
	Pass a direction and the entity faces it
*/
extern void wssprite_face(entity who,int direction);

/*
	Animates and makes the sprite walk
*/
extern void wssprite_walk(entity who,double dist);

/*
	Limits the sprite to the rectangular reigon given
*/
extern void wssprite_limit(entity who,double left,double top,double right,double bottom);

/*
	Turns the sprite into a character
*/
extern void wssprite_character(entity who);

/*
	Changes the layer of the sprite.
	The number provided is the same number provided to wssprite_draw
	in order to draw all sprites in that layer.
*/
extern void wssprite_layer(entity who,int new_layer);

/*
	Changes the offset of the sprite image.
	This is used to actually position the sprite correctly over it's
	bounding box so it displays properly with collisions.

	For example, a tall-type character's feet only have a 16x16 bounding box,
	but it's a 16x32 image. You would make the offset (0,-8) to correct this.
*/
extern void wssprite_offset(entity who,double x,double y);

/* For use by engine */
extern void wssprite_init();
extern void wssprite_reduce();
extern int wssprite_collider();

#endif
