/*
	WeaponSoul Sprites
	written by WolfCoder (2009)

	A sprite is composed of an image, an action, and a hull
*/

/* Includes */
#include "weaponsoul.h"
#include <memory.h>

/* Globals */
unsigned long num_sprites; /* Number of sprites */

/* Initializer */
void wssprite_init()
{
	/* Initial values */
	num_sprites = 0;
}

/* Create a new sprite */
void wssprite_create(action (*beh)(),double x,double y,double z,image body)
{
	entity tempwho;
	/* Create the action */
	wsaction_create(beh);
	tempwho = last;
	/* Position */
	tempwho->x = x;
	tempwho->y = y;
	tempwho->z = z;
	/* Size */
	tempwho->w = wsimage_width(body);
	tempwho->l = wsimage_height(body);
	tempwho->h = tempwho->l;
	tempwho->w /= 2;
	tempwho->l /= 2;
	tempwho->h /= 2;
	/* Auto width */
	tempwho->auto_animation_width = wsimage_frames(body)/3;
	/* Now let's add all the values into an actual sdata */
	tempwho->layer = 0;
	tempwho->s_body = body;
	tempwho->type = ENTITY_SPRITE;
	/* Increment */
	num_sprites++;
}

/* Draw all sprites who's type matches the value given */
void wssprite_draw(int target)
{
	entity drawer;
	unsigned long i;
	int x,y,f;
	/* Go! */
	for(i = 0;i < wsaction_bound();i++)
	{
		/* Check alive */
		if(wsaction_alive(wsaction_data(i)))
		{
			/* Check visible */
			if(!wsaction_data(i)->invisible && wsaction_data(i)->type == ENTITY_SPRITE)
			{
				/* Record temporal values */
				drawer = wsaction_data(i);
				x = (int)(drawer->ox+drawer->dx-drawer->w-wscamera_draw_x());
				y = (int)(drawer->oy+drawer->dy-drawer->l-wscamera_draw_y());
				f = drawer->frame;
				/* Draw */
				wsimage_scale(drawer->dsx,drawer->dsy);
				wsimage_rotate(drawer->p);
				wsimage_alpha(drawer->a);
				wsimage_frame(f);
				wsimage_color(drawer->red,drawer->green,drawer->blue);
				wsimage_subtract(drawer->colormode);
				wsimage_draw(drawer->s_body,x,y);
			}
		}
	}
}

/* Reduce the number of sprites by one */
void wssprite_reduce()
{
	num_sprites--;
}

/* Return the number of sprites in action */
int wssprite_num()
{
	return num_sprites;
}

/* Makes the sprite face a direction */
void wssprite_face(entity who,int direction)
{
	switch(direction)
	{
	case FACE_UP:
		who->frame_base = who->auto_animation_width*2;
		who->sx = 1;
		break;
	case FACE_DOWN:
		who->frame_base = 0;
		who->sx = 1;
		break;
	case FACE_RIGHT:
		who->frame_base = who->auto_animation_width;
		who->sx = 1;
		break;
	case FACE_LEFT:
		who->frame_base = who->auto_animation_width;
		who->sx = -1;
		break;
	}
}

/* Makes the sprite walk some distance provided */
void wssprite_walk(entity who,double dist)
{
	double t;
	/* Increase value */
	if(who->frame_dir == 0)
		who->frame_dist += dist*TIME_STEP; /* Up */
	else
		who->frame_dist -= dist*TIME_STEP; /* Down */
	/* Change direction of animation */
	if(who->frame_dist > 32 && who->frame_dir == 0)
	{
		who->frame_dir = 1;
		who->frame_dist = 32-(32/(double)(who->auto_animation_width));
	}
	if(who->frame_dist <= 0 && who->frame_dir == 1)
	{
		who->frame_dir = 0;
		who->frame_dist = 32/(double)(who->auto_animation_width);
	}
	/* Update frame of animation */
	t = (double)who->auto_animation_width;
	who->frame_add = (int)((who->frame_dist/32.2)*t);
}

/* Restricts the entity to the rectangular reigon defined */
void wssprite_limit(entity who,double left,double top,double right,double bottom)
{
	/* Simply do the 4 if statements */
	if(who->x < left+who->w)
		who->x = left+who->w;
	if(who->x >= right-who->w)
		who->x = right-who->w;
	if(who->y < top+who->l)
		who->y = top+who->l;
	if(who->y >= bottom-who->l)
		who->y = bottom-who->l;
}

/* Sprite collision system */
int wssprite_collider()
{
	/* Return the result of collision */
	return 0;
}

/* Makes the sprite a character */
void wssprite_character(entity who)
{
	/* Set */
	who->auto_animation = 1;
}

/* Changes the layer of the sprite */
void wssprite_layer(entity who,int new_layer)
{
	who->layer = new_layer;
}

/* Changes the offset at which the image appears from the entity itself */
void wssprite_offset(entity who,double x,double y)
{
	/* Set here */
	who->ox = x;
	who->oy = y;
}
