/* WeaponSoul Names */

/* Set string */
void wsstr_set(char *what,char *str,size_t max)
{
	size_t s;
	/* Delete */
	memset(what,0,max);
	/* Check the size */
	s = strlen(str);
	/* Limit */
	if(s > max)
		s = max;
	/* Copy */
#ifndef WIN32
	memcpy(what,str,s);
#endif
#ifdef WIN32
	memcpy_s(what,max,str,s);
#endif
}

/* Compare string */
int wsstr_equal(char *a,char *b,size_t max)
{
	/* Do a strcmp */
	if(strncmp(a,b,max))
		return 0; /* Non-zero value means not equal */
	/* Match */
	return 1;
}

/* Read string from file */
void wsstr_read(char *what,FILE *from,int max)
{
	int i;
	char t;
	/* Delete */
	memset(what,0,max);
	/* Start reading */
	i = 0;
	while(1)
	{
		/* Read */
		fread(&t,1,1,from);
		/* Zero? */
		if(t == 0)
			break;
		what[i] = t;
		i++;
		/* End? */
		if(i >= max)
			break;
	}
	/* Was t zero? */
	if(t == 0)
		return;
	/* Seek it up until zero */
	while(1)
	{
		/* Read */
		fread(&t,1,1,from);
		/* Zero? */
		if(t == 0)
			break;
	}
}

/* Set name */
void wsname_set(name what,char *str)
{
	wsstr_set(what,str,MAX_NAME);
}

/* Compare name */
int wsname_equal(name a,name b)
{
	return wsstr_equal(a,b,MAX_NAME);
}

/* Read a name from a file */
void wsname_read(name what,FILE *from)
{
	wsstr_read(what,from,MAX_NAME);
}

/* Set folder */
void wsfolder_set(folder what,char *str)
{
	wsstr_set(what,str,MAX_FOLDER);
}

/* Compare folder */
int wsfolder_equal(folder a,folder b)
{
	return wsstr_equal(a,b,MAX_FOLDER);
}
