#ifndef WSIMAGE_H
#define WSIMAGE_H

/* Max Field Numbers */
#ifndef MAX_IMAGES
#define MAX_IMAGES 512
#endif

/* Color modes */
#define IMAGE_DARK 1
#define IMAGE_BRIGHT 0

/* Types */
typedef unsigned long image;

/* For use by engine designer */
extern void wsimage_init();
extern void wsimage_exit();
extern unsigned long wsimage_current();

/*
	Load a .WIP file into the engine.

	This loads all the images and their frames into
	the game engine.
*/
extern void wsimage_load(char *filename);

/*
	Frees a .WIP file from the engine.

	This releases resources used by the image.
*/
extern void wsimage_free(char *filename);

/*
	Gets an image, given a name.

	It's usually the file name of the indiviual image
	without the extention (ex: .bmp)
*/
extern image wsimage_get(name what);

/*
	Draws the image, in all the preset parameters (rotation, alpha, ect.)
	at position (x,y) on the screen.
*/
extern void wsimage_draw(image what,int x,int y);

/*
	Sets the display frame for the immediate next frame

	Useful for sprite animations and the like.
*/
extern void wsimage_frame(int frame);

/*
	Sets the scaling factors for the next image.

	Useful for growing and shrinking sprites.
*/
extern void wsimage_scale(double scale_x,double scale_y);

/*
	Sets the rotation angle for the next image.
	Values are in degrees.

	Useful for spinning sprites.
*/
extern void wsimage_rotate(double rot);

/*
	Sets the alpha transparency for the next image.
	1 is fully visible and 0 is invisible.

	Useful for fading in/out.
*/
extern void wsimage_alpha(double alph);

/*
	Sets the next color for the image.
	range 0-1 for each color
*/
extern void wsimage_color(double red,double green,double blue);

/*
	If passed with a non-zero number, the image will be color filtered
	producing darker images instead of color lit like normal
	with the color function
*/
extern void wsimage_subtract(int sub);

/*
	Returns the number of images in use
*/
extern unsigned long wsimage_num();

/*
	Gets the width and height in pixels of a particular image.
*/
extern int wsimage_width(image what);
extern int wsimage_height(image what);

/*
	Gets the number of frames in an image
*/
extern int wsimage_frames(image what);

#endif
