/*
	WeaponSoul Hulls
	Written by WolfCoder (2009)

	This is the entire collision system for the WeaponSoul engine
	It handles collisions between entities that have collision hulls
*/

/* Includes */
#include "weaponsoul.h"

/* Returns true if there's an overlap collision between a sprite and a tileset */
int wshull_sprite_tile(entity sa,entity tb)
{
	int x,y,c;
	int fromx,fromy,tox,toy;
	tilemap_header *data;
	/* Select */
	data = tb->payload;
	/* Calculate fromx and fromy */
	fromx = (int)(sa->x-sa->w-tb->x)/wsimage_width(data->set);
	fromy = (int)(sa->y-sa->l-tb->y)/wsimage_height(data->set);
	/* Calculate tox and toy */
	tox = ((int)(sa->x+sa->w-tb->x)-1)/wsimage_width(data->set);
	toy = ((int)(sa->y+sa->l-tb->y)-1)/wsimage_height(data->set);
	/* Return the tile code if any tiles are non zero */
	for(y = fromy;y <= toy;y++)
	{
		for(x = fromx;x <= tox;x++)
		{
			/* Check */
			c = wstile_collision_get(tb,x,y);
			/* Hit! */
			if(c)
				return c;
		}
	}
	return 0;
}

/* Returns true if a there's an overlap collision between the two objects */
int wshull_check(entity a,entity b)
{
	/* Sprite VS Tilemap */
	if(a->type == ENTITY_SPRITE && b->type == ENTITY_TILEMAP)
		return wshull_sprite_tile(a,b);
	if(a->type == ENTITY_TILEMAP && b->type == ENTITY_SPRITE)
		return wshull_sprite_tile(b,a);
	/* No collisions */
	return 0;
}

/* Returns true if the point given is inside a solid tileset */
int wshull_tileset_point(double x,double y,entity t)
{
	tilemap_header *data;
	/* Select */
	data = t->payload;
	/* Calculate targets */
	return wstile_collision_get(t,(int)(x-t->x)/wsimage_width(data->set),(int)(y-t->y)/wsimage_height(data->set));
}

/* Returns true if the point given is inside a solid entity given */
int wshull_point(double x,double y,double z,entity t)
{
	/* Point VS Tilemap */
	if(t->type == ENTITY_TILEMAP)
		return wshull_tileset_point(x,y,t);
	/* No collisions */
	return 0;
}

