/* Memory allocator tracker */
size_t alloc_traffic = 0;
int num_allocs = 0;
int num_created = 0;
int num_freed = 0;

/* Allocate some memory */
void *wsalloc(size_t len)
{
	void *v;
	/* Check for valid size */
	if(!len)
		wserror_show("Can't allocate memory of size zero.");
	/* Allocate */
	v = malloc(len);
	/* Check for valid allocation */
	if(!v)
		return v; /* Failure to allocate */
	/* Wipe */
	memset(v,0,len);
	/* Account for */
	num_allocs++;
	num_created++;
	alloc_traffic += len;
	/* Return */
	return v;
}

/* Deallocate some memory */
void wsalloc_free(void *what)
{
	/* Deallocate */
	free(what);
	/* Account for only on not null */
	if(what)
	{
		num_allocs--;
		num_freed++;
	}
}

/* Scream error if not matching up */
void wsalloc_check()
{
	/* Recite totals */
	wslog_string("[MEMORY] ");
	wslog_num(num_created);
	wslog_string(" allocations and ");
	wslog_num(num_freed);
	wslog_string(" frees (");
	wslog_num((int)alloc_traffic);
	wslog_string(" bytes traffic).\n");
	/* Check imbalance */
	if(num_allocs)
		wserror_show("Memory leaks detected.");
}
