/*
	WeaponSoul RPG Engine
	written by WolfCoder (2009)
*/

/* Includes */
#include "weaponsoul.h"
#include <GL/gl.h>
#include <SDL.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>

/* Globals */
int engine_running;
int video_running;
SDL_Thread *logic_thread;

/* Parts of the core */
#include "wserror.h"
#include "wsname.h"
#include "wslog.h"
#include "wsinput.h"
#include "wsmode.h"
#include "wsex.h"
#include "wsvideo.h"
#include "wsalloc.h"
#include "wstime.h"

/* Stop the engine */
void ws_quit()
{
	/* Stop all engines */
	engine_running = 0;
}

/* Logic processing */
int ws_logic(void *data)
{
	/* Run loop */
	while(engine_running)
	{
		/* Start time */
		wstime_begin();
		/* Handle actions */
		if(!changing_modes)
			wsaction_main();
		/* Handle the current mode */
		wsmode_body();
		/* End time */
		wstime_end();
	}
	/* Return normal exit */
	return 0;
}

/* Start the engine */
void ws_start()
{
	/* Initialize WeaponSoul */
	wslog_begin();
	wsmode_init();
	wsvideo_init();
	wsinput_init();
	wsimage_init();
	wsaction_init();
	wssprite_init();
	wstile_init();
	/* Enter the main loop */
	engine_running = 1;
	/* Run logic */
	logic_thread = SDL_CreateThread(ws_logic,NULL);
	/* Disable video until safe to play */
	video_running = 0;
	while(engine_running)
	{
		/* Start new mode if starting new mode */
		wsmode_begin();
		/* Handle input and optionally quit */
		wsinput_get();
		/* Draw the result */
		if(video_running)
			wsvideo_main();
		/* Leave an old mode */
		wsmode_end();
	}
	/* Announce termination */
	wslog_string("xxxxxxxxxx  Engine terminated.  xxxxxxxxxx\n");
	/* Wait for threads to finish */
	SDL_WaitThread(logic_thread,NULL);
	/* Game ended. Clean up current mode */
	changing_modes = 1;
	target_mode = 0;
	wsaction_exit();
	wsmode_end();
	wsmode_exit(); /* Global clean up */
	wsinput_exit();
	wsimage_exit();
	wsvideo_exit();
	wsalloc_check();
	wslog_end();
}
