/* Test case 3: all sprites */

/* Entity showing off scale, rotate, and alpha */
action sayuri_crazy()
{
	/* I'm a character */
	wssprite_character(me);
	/* Scale me large */
	wsaction_size(me,2.5);
	wsaction_rotate(me,4,0,0);
	wsaction_color(me,1,0,0,ENTITY_BRIGHT);
	/* I'm alive */
	return 1;
}

/* Entity that you can't see */
action sayuri_invis()
{
	/* I'm a character */
	wssprite_character(me);
	wsaction_invisible(me,1);
	/* I'm alive */
	return 1;
}

/* Entity that is keyboard controlled */
action sayuri_control()
{
	/* I'm a character */
	wssprite_character(me);
	/* Who is stuck onscreen */
	wssprite_limit(me,0,0,wsvideo_width(),wsvideo_height());
	/* Move? */
	if(wsinput_move_y() == -1)
	{
		wssprite_walk(me,3);
		wssprite_face(me,FACE_UP);
		wsaction_move(me,0,-3,0);
	}
	if(wsinput_move_y() == 1)
	{
		wssprite_walk(me,3);
		wssprite_face(me,FACE_DOWN);
		wsaction_move(me,0,3,0);
	}
	/* I'm alive */
	return 1;
}

void test3_init()
{
	test_stage = 3;
	/* Make the property sprite */
	wssprite_create(sayuri_crazy,32,32,0,sayuri_char_img);
	wssprite_create(sayuri_invis,32,64,0,sayuri_char_img);
	wssprite_create(sayuri_control,128,32,0,sayuri_char_img);
}
void test3_main()
{
	/* Mode */
	if(next_fired)
		return;
	if(next_test == -1)
	{
		next_fired = 1;
		wsmode_change(mode_2);
	}
}
void test3_draw()
{
	int i;
	/* Draw sprites */
	wssprite_draw(0);
	/* Draw text */
	wstext_font(mini_font_img);
	wstext_scale(0.5,0.5);
	wstext_draw("You should see a large rotating red character.\nAnd a character that responds to keys on the right of it.",0,wsvideo_height()-32);
	/* Draw key force y */
	wstext_scale(0.5,0.5);
	wstext_draw_real(wsinput_move_y(),0,128);
	/* Draw plugged in controllers */
	wstext_scale(0.5,0.5);
	wstext_draw("Number of Players:",0,128+4);
	wstext_scale(0.5,0.5);
	wstext_draw_num(wsinput_num(),160,128+4);
	/* Draw plugged in controllers names */
	for(i = 0;i < wsinput_num();i++)
	{
		/* Draw name */
		wstext_scale(0.5,0.5);
		wstext_draw(wsplayer_name(i),0,128+8+4*i);
		/* Draw A */
		if(wsplayer_a(i))
		{
			wstext_scale(0.5,0.5);
			wstext_draw("A",160,128+8+4*i);
		}
		/* Draw B */
		if(wsplayer_b(i))
		{
			wstext_scale(0.5,0.5);
			wstext_draw("B",160+4,128+8+4*i);
		}
		/* Draw X */
		wstext_scale(0.5,0.5);
		wstext_draw_num((int)(wsplayer_x(i)*100),160+8,128+8+4*i);
		/* Draw Y */
		wstext_scale(0.5,0.5);
		wstext_draw_num((int)(wsplayer_y(i)*100),160+8+24,128+8+4*i);
	}
}
void test3_exit()
{
}