/* Test Case 2: Actions and Sprites */

/* Resources */
image sayuri_char_img;
double next_spawn = 0;

/* Action that drives the sprite */
typedef struct
{
	double next_dir;
}sayuri_type;
sayuri_type *my_sayuri; /* Rather unnecessary but just tests the local data system */
action sayuri_act()
{
	int newdir;
	/* Load data */
	my_sayuri = my_data;
	/* I am a character */
	wssprite_character(me);
	/* Restrict me to screen */
	wssprite_limit(me,0,0,wsvideo_width(),wsvideo_height());
	/* Change direction */
	if(my_sayuri->next_dir <= 0)
	{
		/* More distance */
		my_sayuri->next_dir = 16+(double)(rand()%16);
		/* Set dir */
		newdir = rand()%4;
		/* Change */
		if(newdir == 0)
		{
			wssprite_face(me,FACE_UP);
			me->vx = 0;
			me->vy = -3;
		}
		if(newdir == 1)
		{
			wssprite_face(me,FACE_RIGHT);
			me->vx = 3;
			me->vy = 0;
		}
		if(newdir == 2)
		{
			wssprite_face(me,FACE_DOWN);
			me->vx = 0;
			me->vy = 3;
		}
		if(newdir == 3)
		{
			wssprite_face(me,FACE_LEFT);
			me->vx = -3;
			me->vy = 0;
		}
	}
	else
	{
		/* Count down */
		my_sayuri->next_dir -= TIME_STEP*2;
	}
	/* Walk */
	wssprite_walk(me,4);
	/* Do not delete */
	return 1;
}

void test2_init()
{
	/* Test stage */
	test_stage = 2;
	/* Get images */
	sayuri_char_img = wsimage_get("sayuri-char");
	/* Vars */
	next_spawn = 0;
}
void test2_main()
{
	/* Create */
	if(next_spawn <= 0)
	{
		next_spawn = 2;
		wssprite_create(sayuri_act,rand()%wsvideo_width()-16,rand()%wsvideo_height()-16,0,sayuri_char_img);
	}
	else
		next_spawn -= TIME_STEP;
	/* Mode */
	if(next_fired)
		return;
	if(next_test == -1)
	{
		next_fired = 1;
		wsmode_change(mode_1);
	}
	if(next_test == 1)
	{
		next_fired = 1;
		wsmode_change(mode_3);
	}
}
void test2_draw()
{
	/* Draw sprites */
	wssprite_draw(0);
	/* Show purpose */
	wstext_scale(0.5,0.5);
	wstext_draw("Num:",wsvideo_width()-32,8);
	wstext_scale(0.5,0.5);
	wstext_draw_num(wsaction_num(),wsvideo_width()-32,8+4);
	wstext_scale(0.5,0.5);
	wstext_draw_num(wsaction_memory(),wsvideo_width()-128,8+4+4);
	wstext_scale(0.5,0.5);
	wstext_draw("We should be wandering around aimlessly.",16,wsvideo_height()-8);
}
void test2_exit()
{
}
