/* Test Case 1: Images */

/* Resources */
image sayuri_face_img;
image firefox_face_img;
image tan_face_img;
image many_face_img;
image happy_face_img;
double sayuri_face_rot;
double firefox_face_flash;
double tan_face_scale;
double face_swap;
int many_face_frame;

void test1_init()
{
	/* Test stage */
	test_stage = 1;
	/* Get face */
	sayuri_face_img = wsimage_get("sayuri-face");
	firefox_face_img = wsimage_get("firefox-face");
	tan_face_img = wsimage_get("95tan-face");
	many_face_img = wsimage_get("many-face");
	happy_face_img = wsimage_get("happy-face");
	/* Set vars */
	sayuri_face_rot = 0;
	firefox_face_flash = 0;
	tan_face_scale = 0.5;
	face_swap = 0;
	many_face_frame = 0;
}
void test1_main()
{
	/* Rotate face */
	sayuri_face_rot += TIME_STEP*2;
	/* Flash face */
	firefox_face_flash += TIME_STEP*0.2;
	if(firefox_face_flash >= 1)
		firefox_face_flash = 0;
	/* Flip face */
	face_swap += TIME_STEP;
	if(face_swap > 8)
	{
		face_swap = 0;
		tan_face_scale = -tan_face_scale;
		many_face_frame++;
		if(many_face_frame >= 3)
			many_face_frame = 0;
	}
	/* Next */
	if(next_fired)
		return;
	if(next_test == 1)
	{
		next_fired = 1;
		wsmode_change(mode_2);
	}
}
void test1_draw()
{
	/* Set font */
	wstext_font(mini_font_img);
	/* Draw the spinning face */
	wsimage_rotate(sayuri_face_rot);
	wsimage_scale(0.5,0.5);
	wsimage_draw(sayuri_face_img,0,0);
	wstext_scale(0.5,0.5);
	wstext_draw("I should be spinning.",16,16+32);
	/* Draw the flashing face */
	wsimage_alpha(firefox_face_flash);
	wsimage_scale(0.5,0.5);
	wsimage_draw(firefox_face_img,0,48);
	wstext_scale(0.5,0.5);
	wstext_draw("I should be flashing.",16,16+32+48);
	/* Draw the flipping face */
	wsimage_scale(tan_face_scale,tan_face_scale);
	wsimage_draw(tan_face_img,0,48*2);
	wstext_scale(0.5,0.5);
	wstext_draw("I should be flipping.",16,16+32+48*2);
	/* Draw the many faces */
	wsimage_scale(0.5,0.5);
	wsimage_frame(many_face_frame);
	wsimage_draw(many_face_img,0,48*3);
	wstext_scale(0.5,0.5);
	wstext_draw("There should be 3 of us.",16,16+32+48*3);
	/* Show reporting */
	wstext_scale(0.5,0.5);
	wstext_draw("Face Image Dimensions:",16,wsvideo_height()-16);
	wstext_scale(0.5,0.5);
	wstext_draw_num(wsimage_width(many_face_img),16,wsvideo_height()-12);
	wstext_scale(0.5,0.5);
	wstext_draw("by",16+16,wsvideo_height()-12);
	wstext_scale(0.5,0.5);
	wstext_draw_num(wsimage_height(many_face_img),16+32,wsvideo_height()-12);
	wstext_scale(0.5,0.5);
	wstext_draw("pixels",16+48,wsvideo_height()-12);
	/* Show scaling */
	wstext_scale(0.5,0.5);
	wstext_draw("All text characters should be half the size as test indicator.",16,wsvideo_height()-8);
	/* Show color filtering */
	wsimage_color(0.5+firefox_face_flash/2,firefox_face_flash,0);
	wsimage_scale(0.5,0.5);
	wsimage_subtract(1);
	wsimage_draw(happy_face_img,128,0);
	wstext_scale(0.5,0.5);
	wstext_draw("I should have color filters.",16+128,16+32);
	/* Show num images */
	wstext_scale(0.5,0.5);
	wstext_draw("Images\nNum  Max  Pos",wsvideo_width()-64,8);
	wstext_scale(0.5,0.5);
	wstext_draw_num(wsimage_num(),wsvideo_width()-64,8+8);
	wstext_scale(0.5,0.5);
	wstext_draw_num(MAX_IMAGES,wsvideo_width()-64+5*4,8+8);
	wstext_scale(0.5,0.5);
	wstext_draw_num(wsimage_current(),wsvideo_width()-64+10*4,8+8);
}
void test1_exit()
{
}