/*
	Test Cases
*/

/* Includes */
#include "weaponsoul.h"

/* Globals */
int test_stage = 0;

/* Test case global display */
mode test_hud_mode;
mode mode_1;
mode mode_2;
mode mode_3;
image mini_font_img;
int next_test;
int next_fired;
void test_hud_init()
{
	/* Prepare the HUD */
	wsimage_load("bin/test.wip");
	mini_font_img = wsimage_get("font-mini");
	/* Set vars */
	next_fired = 0;
}
void test_hud_main()
{
	/* Handle prev/next */
	next_test = 0;
	if(wsinput_move_x() > 0)
		next_test = 1;
	if(wsinput_move_x() < 0)
		next_test = -1;
	if(wsinput_move_x() == 0)
		next_fired = 0;
}
void test_hud_draw()
{
	/* Test case */
	wstext_font(mini_font_img);
	wstext_draw("Test:",4,4);
	wstext_draw_num(test_stage,4+5*8,4);
}
void test_hud_exit()
{
	/* Release hud */
	wsimage_free("bin/test.wip");
}

/* Cases */
#include "testcase1.h"
#include "testcase2.h"
#include "testcase3.h"

/* Begin */
ws_main
{
	/* Title the game */
	ws_title("WeaponSoul Test Suite");
	/* Create the cases */
	mode_1 = wsmode_create_2d(test1_init,test1_main,test1_exit,test1_draw);
	mode_2 = wsmode_create_2d(test2_init,test2_main,test2_exit,test2_draw);
	mode_3 = wsmode_create_2d(test3_init,test3_main,test3_exit,test3_draw);
	/* Create the HUD */
	test_hud_mode = wsmode_create_2d(test_hud_init,test_hud_main,test_hud_exit,test_hud_draw);
	wsmode_global(test_hud_mode,1);
	/* Go! */
	ws_start();
	/* End */
	return 0;
}
