///////////////////////////////////////////////////////////////////////
// WeaponBirth
// - the entry for the Game Chill 2009 Contest by Team Sakura Wolf
///////////////////////////////////////////////////////////////////////

// Paths
path = "src";

// Resource Folders
path = "wbchr";
path = "wbimg";
path = "wbefx";
path = "wbitm";
path = "wbsnd";

// Globals
string temp_str;
var temp_ang[3];
var temp2[3];
var temp_you;

// Character indexes
define REN = 0; // Ren is a wolf-type, he's very strong and full of energy, but with not that much endurance
define HIKARI = 1; // Hikari is a fox-type, she's full of powers and vitality
define NAOMI = 2; // Naomi is a cat-type, she's really fast and resilient
define SARAH = 3; // Sarah is a winged-type, she's one who also has power, but instead of she has tons of energy like Ren

// Required logo
bmap acknex_logo_img = <logolite.pcx>;
panel acknex_panel
{
	bmap = acknex_logo_img;
	flags = d3d,refresh,transparent,visible;
	alpha = 100;
	layer = 999;
}

// Character selection
var character_selected = REN;

// Scantypes
define SCAN_ATTACK = 0;
define SCAN_DETECT = 1;
var scantype = SCAN_ATTACK;

// Includes
include "setting.wdl"; // Sets the engine
include "skill.wdl"; // Entity skills

include "stat.wdl"; // Stats and other game save things
include "popnum.wdl"; // Pop-Up numbers for damage value showings and stuff

include "gui.wdl"; // GUI for the game
include "hud.wdl";
include "card.wdl";

include "camera.wdl"; // Camera systems
include "move.wdl"; // Movement system
include "effect.wdl"; // Effects (my bag o' tricks)
include "character.wdl"; // Cast of characters for the game
include "select.wdl"; // Select characters

include "weapon.wdl"; // Combat system
include "movelistren.wdl"; // Ren's moves
include "movelisthikari.wdl"; // Hikari's moves
include "movelistnaomi.wdl"; // Naomi's moves
include "movelistsarah.wdl"; // Sarah's moves

include "sounds.wdl"; // Same effects only auditory (my noisemakers)

include "ai.wdl"; // Artifical intelligence

include "debug.wdl"; // Debugs the game

// Program entry
function main()
{
	var step = 0;
	
	// Extend the script
	dll_open("wolfie.dll");
	
	// Scale the logo to fit
	acknex_panel.scale_x = screen_size.x/800;
	acknex_panel.scale_y = screen_size.y/600;
	waitt(16); // Wait some time (required)
	// Fade logo out
	while(acknex_panel.alpha > 0)
	{
		acknex_panel.alpha -= time_step*20;
		wait(1);
	}
	acknex_panel.visible = off;
	bmap_purge(acknex_logo_img); // Release from memory
	
	// Fade the presents in
	while(step <= 100)
	{
		gui_presents(step);
		gui_info(step);
		step += time_step*15;
		wait(1);
	}
	gui_presents(step);
	waitt(16);
	// Fade the presents out
	while(step >= 0)
	{
		gui_presents(step);
		gui_info(step);
		step -= time_step*20;
		wait(1);
	}
	gui_presents(0);
	gui_info(0);
	
	// Build database
	stat_init();
	weapon_init();
	
	// Start up systems
	stat_card_handle();
	setting_res_changer();
	gui_hud_handle();
	camera_handle();
	debug_snapshots();
	select_handle();
	weapon_handle_move_slots();
	weapon_handle_control();
	popnum_start();
	
	// Heal all the characters
	stat_full_healing();
	
	// Character selection
	select_open(1);
	while(select_mode == 1){wait(1);}
	
	// Start debuggin'
	debug_start();
	wait(1);
}