// Weapon system

// Defines
define CRITICAL_OWNAGE = 32;

// Makes new weapons and moves
dllfunction weapon_register(mdl,wstr);
//dllfunction weapon_draw(who,wpn);
dllfunction weapon_get_file(wpn);
dllfunction move_register(name,fn,epuse,typ);
dllfunction move_use(epcur,mv);
dllfunction move_set_magnitude(moveid,newmag);
dllfunction move_set_mastery(moveid,newmin,newmax);
dllfunction weapon_damage(who,from,whatmove,whatweapon);
dllfunction weapon_last_critical();
dllfunction move_set_effect(mv,fnc);
dllfunction move_effect_function(mv);

// Move functions
function ren_slash_move();

// Icons
bmap ren_slash_icon = <rblade.pcx>;
bmap hikari_fire_icon = <hscroll.pcx>;
bmap naomi_shoot_icon = <nbow.pcx>;
bmap sarah_bomb_icon = <sgrav.pcx>;

// Pitfall level
var pit_level = -210;

// Number of kills
var kills = 0;

// Move slots
var z_slot_move;
var x_slot_move;
var a_slot_move;

// Weapons
var ren_blade;
var hikari_scroll;
var naomi_bow;
var sarah_hands;

// Moves
var ren_slash;
var hikari_fire;
var naomi_shoot;
var sarah_bomb;

// Make weapons and moves
function weapon_init()
{
	// Register the weapons
	ren_blade = weapon_register("rblade.mdl",1);
	hikari_scroll = weapon_register("hscroll.mdl",1);
	naomi_bow = weapon_register("nbow.mdl",1);
	sarah_hands = weapon_register(" ",0);
	// Register the moves
	ren_slash = move_register("Slash","ren_slash_move",0,TYPE_WEAPON); // Ren takes a swing
	move_set_mastery(ren_slash,80,110); // High mastery with occasional over damage
	move_set_effect(ren_slash,"ren_slash_hit_effect"); // Set hit sparks
	hikari_fire = move_register("Fire","hikari_fire_move",0,TYPE_ETHER); // Hikari throws fire
	move_set_mastery(hikari_fire,95,100); // Stable damage
	naomi_shoot = move_register("Shoot","naomi_shoot_move",0,TYPE_SKILL); // Naomi shoots an arrow
	move_set_mastery(naomi_shoot,75,125); // Wide mastery
	move_set_effect(naomi_shoot,"naomi_arrow_hit_effect"); // Set hit sparks
	sarah_bomb = move_register("Gravity Bomb","sarah_bomb_move",0,TYPE_ETHER); // Sarah throws a gravity bomb
	move_set_mastery(sarah_bomb,100,120); // Strong move
}

// Handle pitfalls
function weapon_pitfall()
{
	// Wait
	while(my != null)
	{
		// Below line?
		if(my.z < pit_level)
		{
			my.health = 0;
			weapon_death();
		}
		wait(1);
	}
}


// Handles weapon
function weapon_action()
{
	// Passable
	my.passable = on;
	my.holder = you;
	// Run
	while(you != null)
	{
		// Attach
		vec_set(my.x,you.x);
		my.pan = character_match_face_angle(you.aim)+you.hold_pan;
		my.tilt = you.hold_tilt;
		my.roll = you.hold_roll;
		my.frame = you.hold_frame;
		my.z += you.hold_z;
		// Release?
		if(you.hold_release != 0 || you.health <= 0)
		{
			// Let go!
			you = null;
		}
		wait(1);
	}
	// Vanish
	ent_remove(me);
}

// Moves a weapon forward and returns 1 if an enemy was hit (or wall)
function weapon_move(amt)
{
	// If we're too far away from our launcher, we will vanish
	if(you != null)
	{
		if(vec_dist(me.x,you.x) > 8192)
		{
			// I'm gone
			my.hold_release = 1;
			// Hit nothing
			return(0);
		}
	}
	// Determine the amount to move
	temp.x = amt*time_step;
	temp.y = 0;
	temp.z = 0;
	// Rotate it
	temp_ang.pan = my.pan;
	temp_ang.tilt = my.tilt;
	temp_ang.roll = my.roll;
	vec_rotate(temp,temp_ang);
	// Addition
	temp2.x = my.x+temp.x;
	temp2.y = my.y+temp.y;
	temp2.z = my.z+temp.z;
	// Check it
	temp_you = you;
	// Hit detection
	if(c_trace(my.x,temp2.x,IGNORE_PASSABLE|IGNORE_PASSENTS|IGNORE_ME|IGNORE_YOU|ACTIVATE_SHOOT) != 0)
	{
		// Addition
		vec_add(my.x,temp);
		// Hit SOMEONE
		if(you != null)
		{
			// On the same team
			if(you.team == my.team)
			{
				// Go through them
				you = temp_you;
				return(0);
			}
			// Is dead?
			if(you.health <= 0)
			{
				you = temp_you;
				return (0);
			}
			// Strike!
			you = temp_you;
			return(1);
		}
		else
		{
			// No one
			you = temp_you;
			return(1);
		}
		// Catch all detonate
		you = temp_you;
		return(1);
	}
	// Hit nothing
	vec_add(my.x,temp);
	you = temp_you;
	return(0);
}

// Draws weapon
function weapon_draw(wpn)
{
	// Make it
	my.hold_release = 0;
	ent_create(weapon_get_file(wpn),my.x,weapon_action);
}

// Kills characters
function weapon_death()
{
	// If we still have health we are not dead
	if(my.health > 0)
	{
		return;
	}
	// AAAAAAAHHHH!!
	my.event = null;
	// Zero out
	my.health = 0;
	my.pwned = 4;
	my.animation_mode = DOWNED;
	// Red flash!
	my.transparent = on;
	my.alpha = 100;
	my.red = 255;
	my.green = 0;
	my.blue = 0;
	my.light = on;
	my.lightrange = 0;
	// Fade away
	while(my.alpha > 0)
	{
		// Die
		if(my.alpha < 50)
		{
			// Fall down more
			my.pwned = 80;
		}
		// Fade out
		my.alpha -= time_step*10;
		my.red = (my.alpha/100)*255;
		wait(1);
	}
	// Gone
	wait(1);
	ent_remove(me);
}

// Pushes the current entity in the direction of the attacker by some magnitude
function weapon_knockback(mag)
{
	// Set
	temp.x = mag;
	temp.y = 0;
	temp.z = 0;
	// Rotate
	vec_rotate(temp,attacker_dir);
	// Apply
	my.force_x = temp.x;
	my.force_y = temp.y;
	my.force_z = temp.z;
}

// Assigns a build
function weapon_assign_build(bld,lev)
{
	// Set build and level
	my.build = bld;
	my.level = lev;
	// Refill health
	my.health = stat_maxhp(bld,lev);
	my.energy = stat_maxep(bld,lev);
}

// Does a melee attack
function weapon_melee_hit(wd,rng)
{
	temp_ang.pan = character_match_face_angle(my.aim);
	temp_ang.tilt = 0;
	temp_ang.roll = 0;
	temp.x = wd;
	temp.y = 0;
	temp.z = rng;
	c_scan(my.x,temp_ang,temp,IGNORE_ME|SCAN_ENTS|SCAN_LIMIT);
}

// Does an explosive attack
function weapon_explode_hit(rng)
{
	temp_ang.pan = 0;
	temp_ang.tilt = 0;
	temp_ang.roll = 0;
	temp.x = 360;
	temp.y = 360;
	temp.z = rng;
	c_scan(my.x,temp_ang,temp,IGNORE_ME|SCAN_ENTS|SCAN_LIMIT);
}

// Copies status temp attack vars from my
function weapon_generate_damage(mv)
{
	attacker = me;
	attacker_build = my.build;
	attacker_lv = my.level;
	attacker_team = my.team;
	attacker_move = mv;
	attacker_weapon = my.weapon;
	attacker_dir.pan = character_match_face_angle(my.aim)+my.hold_pan;
	attacker_dir.tilt = my.hold_tilt;
	attacker_dir.roll = 0;
}

// Copies status temp attack vars from you
function weapon_inherit_damage(mv)
{
	// YOU is valid?
	if(you == null)
	{
		return;
	}
	// Assign
	attacker = you;
	attacker_build = you.build;
	attacker_lv = you.level;
	attacker_team = you.team;
	attacker_move = mv;
	attacker_weapon = you.weapon;
	attacker_dir.pan = my.pan;
	attacker_dir.tilt = you.hold_tilt;
	attacker_dir.roll = 0;
}

// Invokes an NPC move
function weapon_npc_move(mv)
{
	// Can't use if attacking or being hurt
	if(my.attacking == 1 || my.pwned > 0 || my.health <= 0)
	{
		return;
	}
	// Attempt to use the move
	my.energy = move_use(my.energy,mv);
}

// Invokes a player move
function weapon_use_move(mv)
{
	// Attempt to use the move
	me = player;
	my.energy = move_use(my.energy,mv);
}

// Draws the current weapon for NPC
function weapon_draw_equipment()
{
	// Create
	weapon_draw(me.weapon);
	//weapon_style(); // Prepare
	//my_weapon.pan = character_match_face_angle(me.aim);
	// Remember
	//my.held = my_weapon;
}

// Enforces move sets for all characters
function weapon_handle_move_slots()
{
	var weapon_handle_selected = -1;
	while(1)
	{
		// Wait for change
		while(weapon_handle_selected == character_selected){wait(1);}
		// Ren?
		if(character_selected == REN)
		{
			// Assign weapons
			if(player != null)
			{
				// Ren's lightning rod blade
				player.weapon = ren_blade;
			}
			// Assign icons
			z_move_icon.bmap = ren_slash_icon;
			// Assign moves
			z_slot_move = ren_slash;
		}
		// Hikari?
		if(character_selected == HIKARI)
		{
			// Assign weapons
			if(player != null)
			{
				// Hikari's scrolls
				player.weapon = hikari_scroll;
			}
			// Assign icons
			z_move_icon.bmap = hikari_fire_icon;
			// Assign moves
			z_slot_move = hikari_fire;
		}
		// Naomi?
		if(character_selected == NAOMI)
		{
			// Assign weapons
			if(player != null)
			{
				// Naomi's arrows
				player.weapon = naomi_bow;
			}
			// Assign icons
			z_move_icon.bmap = naomi_shoot_icon;
			// Assign moves
			z_slot_move = naomi_shoot;
		}
		// Sarah?
		if(character_selected == SARAH_HANDS)
		{
			// Assign weapons
			if(player != null)
			{
				// Sarah has no weapon
				player.weapon = sarah_hands;
			}
			// Assign icons
			z_move_icon.bmap = sarah_bomb_icon;
			// Assign moves
			z_slot_move = sarah_bomb;
		}
		wait(1);
	}
}

// Allows the player to use skills
function weapon_handle_control()
{
	while(1)
	{
		// Is the player alive?
		if(player != null)
		{
			// Z move used?
			if(key_z == 1)
			{
				// Use it
				weapon_use_move(z_slot_move);
			}
			// Wait until done attacking
			while(player.attacking == 1){wait(1);}
		}
		// Anti auto-fire locks
		while(key_z == 1){wait(1);}
		wait(1);
	}
}

// Makes the ME entity take a hit
function weapon_take_hit()
{
	var damg;
	// Calculate the damage
	damg = weapon_damage(me,attacker,attacker_move,attacker_weapon);
	my.health -= damg;
	popnum_show(damg);
	// Generate effect
	move_effect_function(attacker_move);
	// Get thrown down if critical
	if(weapon_last_critical() == 1)
	{
		// OWNED!
		my.pwned = CRITICAL_OWNAGE;
		my.animation_mode = DOWNED;
		// WOAAAAA!
		weapon_knockback(8);
		move_defy_gravity();
		my.move_g = 10;
	}
	else
	{
		// Knockback
		weapon_knockback(8);
	}
}

// Get back up if knocked down
function character_ai_get_up()
{
	while(my != null)
	{
		// Only if alive
		if(my.health > 0)
		{
			// While hurt
			while(my.animation_mode == DOWNED)
			{
				// The AI needs to wait a short moment to shake it off
				if(my.landed == 1)
				{
					my.pwned -= time_step*1.75;
				}
				// Go back to walking
				if(my.pwned <= 0)
				{
					my.animation_mode = WALKING;
				}
				// End
				wait(1);
			}
		}
		// End
		wait(1);
	}
}

// Player event
function character_player_event()
{
		// Hit
	if(event_type == EVENT_SCAN)
	{
		// Check team
		if(attacker_team == my.team)
		{
			return;
		}
		// Get hit
		weapon_take_hit();
	}
	// Check for death
	weapon_death();
}

// Friendly event
function character_friendly_event()
{
	// Hit
	if(event_type == EVENT_SHOOT)
	{
		// Check team
		if(attacker_team == my.team)
		{
			return;
		}
		// Check bullets
		if(you.bullet != 1)
		{
			return;
		}
		// Get hit
		you.hold_release = 1;
		weapon_take_hit();
	}
	if(event_type == EVENT_SCAN && scantype == SCAN_ATTACK)
	{
		// Check team
		if(attacker_team == my.team)
		{
			return;
		}
		// Get hit
		weapon_take_hit();
	}
	// Check for death
	weapon_death();
}

// Friendlies
function character_friendly()
{
	// I'm a character sprite
	char_style();
	character_npc();
	character_ai_get_up();
	weapon_pitfall();
	my.push = PUSH_CHAR;
	my.team = TEAM_FRIEND;
	my.enable_scan = on;
	// Event
	my.event = character_friendly_event;
}

// Enemy event
function character_enemy_event()
{
	// Hit
	if(event_type == EVENT_SHOOT)
	{
		// Check team
		if(attacker_team == my.team)
		{
			return;
		}
		// Check bullets
		if(you.bullet != 1)
		{
			return;
		}
		// Get hit
		you.hold_release = 1;
		weapon_take_hit();
	}
	if(event_type == EVENT_SCAN && scantype == SCAN_ATTACK)
	{
		// Check team
		if(attacker_team == my.team)
		{
			return;
		}
		// Get hit
		weapon_take_hit();
	}
	// Killed by player?
	if(my.health <= 0 && attacker == player)
	{
		// Ching! Add it to the kills
		kills += 1;
	}
	// Check for death
	weapon_death();
}

// Enemies
function character_enemy()
{
	// I'm an enemy sprite
	char_style();
	character_npc();
	character_ai_get_up();
	weapon_pitfall();
	my.push = PUSH_CHAR;
	my.team = TEAM_ENEMY;
	my.enable_scan = on;
	my.enable_shoot = on;
	// Event
	my.event = character_enemy_event;
}

// Mirror status
function player_mirror_status()
{
	while(1)
	{
		// Mirror stats
		hp = my.health;
		ep = my.energy;
		// End
		wait(1);
	}
}

// Player action
function player_action
{
	// I'm the player
	player = me;
	my.push = PUSH_USER;
	my.team = TEAM_FRIEND;
	my.enable_scan = on;
	// Am I winged?
	if(character_selected == SARAH)
	{
		my.winged = 1;
	}
	// Look like a character
	char_style();
	// Immediatly morph into selected char
	char_use_player_character(character_selected);
	my.build = character_selected;
	my.level = lvl;
	my.health = stat_maxhp(character_selected,lvl);
	my.energy = stat_maxhp(character_selected,lvl);
	// Focus camera
	camera_focus(me);
	// Attach control
	character_control();
	character_control_jump();
	player_mirror_status();
	weapon_pitfall();
	// Event
	my.event = character_player_event;
}