// Sound Effects

// Globals
var temp_snd;

// Resources
sound ren_blade_snd = <renblade.wav>; // Blade swings
sound ren_blade_hit_snd = <renbladehit.wav>; // Blade hits
sound throw_scroll_snd = <throwscroll.wav>; // Scroll throws
sound fire_blast_snd = <fireblast.wav>; // Fire blasting
sound arrow_shoot_snd = <arrowshoot.wav>; // Arrows shooting
sound arrow_hit_snd = <arrowhit.wav>; // Arrows hitting
sound fire_snd = <fire.wav>; // Generic fire
sound implode_snd = <implode.wav>; // Implosion

// Generates gravity exlosions
function sound_gravity_explode()
{
	temp_snd = ent_playsound(me,implode_snd,600);
	snd_tune(temp_snd,50,80+random(40),0);
}

// Generates REN blade swings
function sound_ren_blade()
{
	// Take a swing
	temp_snd = ent_playsound(me,ren_blade_snd,256);
	snd_tune(temp_snd,100,45+random(25),0);
}

// Generates REN blade hits
function sound_ren_blade_hit()
{
	// Land a metal blade hit
	temp_snd = ent_playsound(me,ren_blade_hit_snd,500);
	snd_tune(temp_snd,100,175+random(25),0);
	// CRITICAL HIT!
	if(weapon_last_critical() == 1)
	{
		// TRIPLE strike and low freq
		snd_tune(temp_snd,100,50,0);
	}
}

// Throws scroll effect
function sound_throw_scroll()
{
	temp_snd = ent_playsound(me,throw_scroll_snd,256);
	snd_tune(temp_snd,90+random(10),100+random(10),0);
}

// Fire blast effect
function sound_fire_blast()
{
	// Blast fire
	temp_snd = ent_playsound(me,fire_blast_snd,500);
	snd_tune(temp_snd,100,120+random(25),0);
	temp_snd = ent_playsound(me,fire_snd,500);
	snd_tune(temp_snd,25,100+random(5),0);
}

// Shooting arrows
function sound_shoot_arrow()
{
	// Shoot
	temp_snd = ent_playsound(me,arrow_shoot_snd,400);
	snd_tune(temp_snd,100,90+random(10),0);
}

// Landing arrows
function sound_hit_arrow()
{
	// Hit!
	temp_snd = ent_playsound(me,arrow_hit_snd,500);
	snd_tune(temp_snd,100,100+random(25),0);
	// CRITICAL HIT!
	if(weapon_last_critical() == 1)
	{
		// TRIPLE strike and low freq
		snd_tune(temp_snd,100,75,0);
	}
}