// This is the select screen where you choose people to play as

// Mode var
var select_mode = 0;
var select_flash = 50;

// Resources
bmap char_highlight_img = <charhigh.pcx>;

// Selection
panel select_list_panel
{
	digits = 0,-24,"Please select a character:",text_font,1,0;
	window = 0,0,16,16,char_icon_img,0,0;
	digits = 20,4,"Wolf",small_font,1,0;
	window = 0,24,16,16,char_icon_img,16,0;
	digits = 20,28,"Fox",small_font,1,0;
	window = 0,48,16,16,char_icon_img,32,0;
	digits = 20,52,"Cat",small_font,1,0;
	window = 0,72,16,16,char_icon_img,48,0;
	digits = 20,76,"Winged",small_font,1,0;
	flags = d3d,refresh,overlay,transparent;
	alpha = 100;
	layer = 5;
}
panel char_highlight_panel
{
	bmap = char_highlight_img;
	flags = d3d,refresh,overlay,transparent;
	alpha = 25;
	layer = 4;
}

// Moves selection list
function select_list(xx,yy,dd)
{
	if(dd == 0)
	{
		// Remove
		select_list_panel.visible = off;
		char_highlight_panel.visible = off;
		return;
	}
	// Flash
	select_flash += ((25-select_flash)/4)*time_step;
	char_highlight_panel.alpha = select_flash;
	// Scale
	select_list_panel.scale_x = video_scale;
	select_list_panel.scale_y = video_scale;
	char_highlight_panel.scale_x = video_scale;
	char_highlight_panel.scale_y = video_scale;
	// Move
	select_list_panel.pos_x = xx;
	select_list_panel.pos_y = yy;
	char_highlight_panel.pos_x = xx;
	char_highlight_panel.pos_y = yy+(character_selected*24)*video_scale;
	// On
	select_list_panel.visible = on;
	char_highlight_panel.visible = on;
}

// Handles the movement
function select_handle_input()
{
	while(1)
	{
		// On?
		if(select_mode == 1)
		{
			// Let changing
			if(key_cuu == 1 && character_selected > 0)
			{
				character_selected -= 1;
				stat_full_healing();
				select_flash = 100;
			}
			if(key_cud == 1 && character_selected < 3)
			{
				character_selected += 1;
				stat_full_healing();
				select_flash = 100;
			}
			// Select!
			if(key_z == 1)
			{
				// Close it
				select_open(0);
			}
			// Anti auto fire
			while(key_cuu == 1 || key_cud == 1){wait(1);}
		}
		// End
		wait(1);
	}
}

// Handles that screen
function select_handle()
{
	// Needs this
	select_handle_input();
	// Enter
	while(1)
	{
		// On
		if(select_mode == 1)
		{
			// Open
			stat_card_show(1);
			select_list(32*video_scale,32+16*video_scale,100);
		}
		else
		{
			// Close
			stat_card_show(0);
			select_list(0,0,0);
		}
		// End
		wait(1);
	}
}

// Sets the select
function select_open(md)
{
	// Set mode
	select_mode = md;
}