// Naomi's moves
function naomi_arrow_hit()
{
	// Strike!
	sound_hit_arrow();
	// Position
	my.passable = on;
	my.facing = off;
	my.oriented = on;
	my.nofilter = on;
	my.pan = random(360);
	my.tilt = random(360);
	my.roll = random(360);
	// Bright
	effect_make_bright();
	// Fade out and grow
	while(my.alpha > 0)
	{
		my.roll += time_step*5;
		my.alpha -= time_step*25;
		my.scale_x += time_step;
		my.scale_y = my.scale_x;
		my.scale_z = my.scale_x;
		wait(1);
	}
	// Die
	ent_remove(me);
}
function naomi_arrow_hit_effect()
{
	// Make two
	ent_create("arrowhit.pcx",my.x,naomi_arrow_hit);
	ent_create("arrowhit.pcx",my.x,naomi_arrow_hit);
}
function naomi_arrow_fly()
{
	var stick;
	// Weaponry
	my.passable = on;
	my.shadow = on;
	my.team = you.team;
	my.bullet = 1;
	my.tilt += 5;
	// Point
	my.pan = character_match_face_angle(you.aim);
	// Fly
	while(my != null)
	{
		// Generate shooting damage always
		weapon_inherit_damage(naomi_shoot);
		// Stricken someone, remove
		if(my.hold_release == 1)
		{
			ent_remove(me);
		}
		else
		{
			// Not stuck
			if(stick <= 0)
			{
				// Zoom!
				if(weapon_move(50) == 1)
				{
					// Stick!
					stick = 1;
				}
				// Aim down
				my.tilt -= time_step*1.5;
				// Straight down is the end
				if(my.tilt < -90)
				{
					my.tilt = -90;
				}
			}
			else
			{
				// Vanish after a moment
				stick += time_step;
				if(stick >= 24)
				{
					my.transparent = on;
					my.alpha -= time_step*2;
					if(my.alpha <= 0)
					{
						ent_remove(me);
					}
				}
			}
		}
		wait(1);
	}
}
function naomi_shoot_move()
{
	// Ready
	my.attacking = 1;
	weapon_draw(my.weapon);
	my.hold_z = -8;
	// Draw back on the bow
	my.hold_frame = 2;
	waitt(4);
	// Launch!
	sound_shoot_arrow();
	ent_create("narrow.mdl",vector(my.x,my.y,my.z-8),naomi_arrow_fly);
	my.hold_frame = 1;
	waitt(4);
	// Done
	my.hold_release = 1;
	my.attacking = 0;
}