// Movement subsystem

// Pushing bases
define PUSH_USER = 30;
define PUSH_CHAR = 15;
define PUSH_CHAR_MOVE = 45;

// Defines
define pwnage_fall_threshold = 300;
define pwnage_fall_val = 32;
define pwnage_bounce = 9;
define pwnage_friction = 7; // Higher numbers make you slide more

// Gravitation
var move_gravity = 2.30;

// Uppers movement
function move_prepare_push()
{
	// If a char
	if(my.push == PUSH_CHAR)
	{
		// Champion
		my.push = PUSH_CHAR_MOVE;
	}
}

// Restores movement
function move_restore_push()
{
	// If a char
	if(my.push == PUSH_CHAR_MOVE)
	{
		// Restore
		my.push = PUSH_CHAR;
	}
}

// Launches jumps
function move_defy_gravity()
{
	// Move upwards to prevent terrain sticking
	temp.x = 0;
	temp.y = 0;
	temp.z = 1;
	move_prepare_push();
	move_mode = IGNORE_PASSABLE|IGNORE_PASSENTS|GLIDE|IGNORE_PUSH;
	c_move(me,nullvector,temp,move_mode);
	move_restore_push();
}

// Handles gravity for a frame
function move_apply_gravity()
{
	// Not landed
	my.landed = 0;
	// Create trace vector
	temp.x = my.x;
	temp.y = my.y;
	temp.z = my.z-1;
	// Trace it
	c_trace(my.x,temp,IGNORE_ME|IGNORE_PASSABLE|IGNORE_PASSENTS|IGNORE_PUSH|USE_BOX);
	// Calculate the normal angles for the floor
	vec_to_angle(temp_ang,normal); // Make angle
	// Friction during pwnage
	if(my.pwned > 0)
	{
		// Apply it (if not being thrown)
		if(my.landed == 1)
		{
			my.move_x += ((-my.move_x)/pwnage_friction)*time_step;
			my.move_y += ((-my.move_y)/pwnage_friction)*time_step;
			my.move_z += ((-my.move_z)/pwnage_friction)*time_step;
		}
	}
	// Check to see if landed for jumping
	if(result != 0)
	{
		// Check for pwnage
		if(my.fall_dist > pwnage_fall_threshold*(2.30/move_gravity)) // Higher gravity lowers the max dist before getting harmed
		{
			// OUCH!
			my.pwned = pwnage_fall_val;
			// Reset dist
			my.fall_dist = 0;
			// Launch
			move_defy_gravity();
			my.move_g = pwnage_bounce;
			return;
		}
		else
		{
			// Landed
			my.landed = 1;
		}
		// Reset dist
		my.fall_dist = 0;
	}
	// .. and if we're landed, jump and we're not landed anymore
	if(my.landed == 1 && my.jump > 0)
	{
		// Launch
		move_defy_gravity();
		// Transfer jumping power into move g
		my.move_g = my.jump;
		my.jump = 0;
		// Set landing to 0
		my.landed = 0;
	}
	else
	{
		// Reset jumping anyways
		my.jump = 0;
		// Hit?
		if(result != 0 && temp_ang.tilt >= 35)
		{
			// Cancel movement
			my.move_g = 0;
			if(temp_ang.tilt < 40)
			{
				my.move_g = -1;
			}
			return;
		}
	}
	// Go!
	my.move_g -= move_gravity*time_step;
	// Reduce terminal velocity if winged
	if(my.winged == 1)
	{
		my.move_g = max(-10,my.move_g);
	}
}

// Applies friction to the forces unless in air
function move_apply_force_friction()
{
	// On ground?
	if(my.landed == 1)
	{
		// Slide
		my.force_x += ((-my.force_x)/2)*time_step;
		my.force_y += ((-my.force_y)/2)*time_step;
		my.force_z += ((-my.force_z)/2)*time_step;
	}
}

// Attaches movement system to this object
function move_handle()
{
	var temp_fall_z;
	// While i am valid
	while(my != null)
	{
		// Gravity?
		move_apply_gravity();
		// Start z
		temp_fall_z = my.z;
		// Calculate vector and move
		temp.x = (my.move_x+my.force_x)*time_step;
		temp.y = (my.move_y+my.force_y)*time_step;
		temp.z = (my.move_z+my.move_g+my.force_z)*time_step;
		// Reduce force
		move_apply_force_friction();
		move_prepare_push();
		move_mode = IGNORE_PASSABLE|IGNORE_PASSENTS|GLIDE|IGNORE_PUSH;
		c_move(me,nullvector,temp,move_mode);
		move_restore_push();
		// Add up the falling
		my.fall_dist -= my.z-temp_fall_z;
		// End
		wait(1);
	}
}