// This section has grown so much that it deserves its own code file

// Resources
bmap face_box_img = <facebox.pcx>;
bmap label_plate_img = <labelplate.pcx>;
bmap level_label_img = <lvlabel.pcx>;
bmap hp_bar_img = <hpbar.pcx>;
bmap hp_anim_img = <hpanim.pcx>;
bmap hp_label_img = <hplabel.pcx>;
bmap ep_label_img = <eplabel.pcx>;
bmap move_slot_img = <moveslot.pcx>;
bmap slot_key_img = <slotkey.pcx>;
bmap null_icon_img = <nullicon.pcx>;

// Here's the health display
var hp_bar_show_val = 80;
var hp_bar_anim_val = 0;
var hp_bar_seg = 0;
panel hp_bar_panel
{
	window = 0,0,80,8,hp_bar_img,hp_bar_show_val,0;
	flags = d3d,refresh,transparent,overlay;
	layer = 1;
	alpha = 100;
}
panel hp_anim_panel
{
	window = 0,0,80,8,hp_anim_img,hp_bar_anim_val,hp_bar_seg;
	flags = d3d,refresh,transparent,overlay;
	layer = 2;
	alpha = 50;
}
panel hp_label_panel
{
	bmap = hp_label_img;
	flags = d3d,refresh,transparent,overlay;
	layer = 3;
	alpha = 100;
}
panel hp_number_panel
{
	digits = 0,0,3,small_font,1,hp;
	flags = d3d,refresh,transparent,overlay;
	layer = 3;
	alpha = 100;
}
function gui_hp_plate(xx,yy,dd)
{
	// Off
	if(dd <= 0)
	{
		hp_bar_panel.visible = off;
		hp_anim_panel.visible = off;
		hp_label_panel.visible = off;
		hp_number_panel.visible = off;
		return;
	}
	// Calculate pos
	if(hp == 0)
	{
		hp_bar_show_val = 80;
		hp_bar_seg = 16;
		hp_anim_panel.alpha += ((-hp_anim_panel.alpha)/20)*time_step;
	}
	else
	{
		hp_bar_show_val += (((80-80*(hp/stat_maxhp(character_selected,lvl)))-hp_bar_show_val)/2)*time_step;
		hp_bar_anim_val += ((hp/stat_maxhp(character_selected,lvl))*1.5)*time_step;
		if(hp_bar_anim_val > 16)
		{
			hp_bar_anim_val = 0;
		}
		// Fade when dying
		hp_anim_panel.alpha = 25+25*(hp/stat_maxhp(character_selected,lvl));
		// Change color if low
		hp_bar_seg = 0;
		if(hp < stat_maxhp(character_selected,lvl)/2)
		{
			hp_bar_seg = 8;
		}
		if(hp < stat_maxhp(character_selected,lvl)/3)
		{
			hp_bar_seg = 16;
		}
	}
	// Move
	hp_bar_panel.pos_x = xx+2*video_scale;
	hp_bar_panel.pos_y = yy+2*video_scale;
	hp_anim_panel.pos_x = xx+2*video_scale;
	hp_anim_panel.pos_y = yy+2*video_scale;
	hp_label_panel.pos_x = xx;
	hp_label_panel.pos_y = yy;
	hp_number_panel.pos_x = xx+(80-24)*video_scale;
	hp_number_panel.pos_y = yy;
	// Scale
	hp_bar_panel.scale_x = video_scale;
	hp_bar_panel.scale_y = video_scale;
	hp_anim_panel.scale_x = video_scale;
	hp_anim_panel.scale_y = video_scale;
	hp_label_panel.scale_x = video_scale;
	hp_label_panel.scale_y = video_scale;
	hp_number_panel.scale_x = video_scale;
	hp_number_panel.scale_y = video_scale;
	// On
	hp_bar_panel.visible = on;
	hp_anim_panel.visible = on;
	hp_label_panel.visible = on;
	hp_number_panel.visible = on;
}

// This displays the current level
panel level_plate_panel
{
	bmap = label_plate_img;
	flags = d3d,refresh,transparent,overlay;
	layer = 1;
	alpha = 100;
}
panel level_label_panel
{
	bmap = level_label_img;
	flags = d3d,refresh,transparent,overlay;
	layer = 2;
	alpha = 100;
}
panel level_number_panel
{
	digits = 0,0,3,small_font,1,lvl;
	flags = d3d,refresh,transparent,overlay;
	layer = 2;
	alpha = 100;
}
function gui_level_plate(xx,yy,dd)
{
	// Off
	if(dd <= 0)
	{
		level_plate_panel.visible = off;
		level_label_panel.visible = off;
		level_number_panel.visible = off;
		return;
	}
	// Position
	level_plate_panel.pos_x = xx+2*video_scale;
	level_plate_panel.pos_y = yy+2*video_scale;
	level_label_panel.pos_x = xx;
	level_label_panel.pos_y = yy;
	level_number_panel.pos_x = xx+24*video_scale;
	level_number_panel.pos_y = yy;
	// Scale
	level_plate_panel.scale_x = video_scale;
	level_plate_panel.scale_y = video_scale;
	level_label_panel.scale_x = video_scale;
	level_label_panel.scale_y = video_scale;
	level_number_panel.scale_x = video_scale;
	level_number_panel.scale_y = video_scale;
	// On
	level_plate_panel.visible = on;
	level_label_panel.visible = on;
	level_number_panel.visible = on;
}

// This reflects whatever move is slotted to the Z key
panel z_move_panel
{
	bmap = move_slot_img;
	window = -2,18,8,8,slot_key_img,0,0;
	flags = d3d,refresh,transparent,overlay;
	alpha = 100;
	layer = 5;
}
panel z_move_icon
{
	bmap = null_icon_img;
	flags = d3d,refresh,transparent,overlay;
	alpha = 100;
	layer = 10;
}
function gui_slot_panel(xx,yy,dd)
{
	if(dd == 0)
	{
		// Turn off
		z_move_panel.visible = off;
		z_move_icon.visible = off;
		return;
	}
	// Move
	z_move_panel.pos_x = xx;
	z_move_panel.pos_y = yy;
	z_move_icon.pos_x = xx+4*video_scale;
	z_move_icon.pos_y = yy+4*video_scale;
	// Scale
	z_move_icon.scale_x = video_scale;
	z_move_icon.scale_y = video_scale;
	z_move_panel.scale_x = video_scale;
	z_move_panel.scale_y = video_scale;
	// Turn on
	z_move_panel.visible = on;
	z_move_icon.visible = on;
}

// This handles the HUD
var gui_hud_pos = 0;
var gui_hud_open_mode = 0;
panel face_panel
{
	bmap = face_box_img;
	flags = d3d,refresh,transparent,overlay;
	alpha = 100;
}
function gui_hud(dist)
{
	var guirank;
	// Vanish
	if(dist <= 0)
	{
		face_panel.visible = off;
		return;
	}
	// Calc
	guirank = -96+(96*(dist/100));
	// Scroll onscreen
	face_panel.pos_x = 16;
	face_panel.pos_y = 16+guirank;
	face_panel.scale_x = video_scale/2;
	face_panel.scale_y = video_scale/2;
	// Show level
	gui_level_plate(16+48*(video_scale/2)+8*video_scale,16+guirank,dist);
	// Show HP
	gui_hp_plate(16+48*(video_scale/2)+8*video_scale,16+guirank+12*video_scale,dist);
	// Show slots
	gui_slot_panel(16,screen_size.y-32*video_scale-guirank,dist);
	// Show
	face_panel.visible = on;
}
function gui_hud_handle()
{
	// Enter
	while(1)
	{
		// Opening?
		if(gui_hud_open_mode == 1)
		{
			gui_hud_pos += ((100-gui_hud_pos)/2)*time_step;
		}
		// Closing?
		if(gui_hud_open_mode == 0)
		{
			gui_hud_pos += ((-gui_hud_pos)/2)*time_step;
		}
		// Update
		gui_hud(gui_hud_pos);
		// End
		wait(1);
	}
}

// Opens/closes the HUD
function gui_hud_open(op)
{
	// Set
	gui_hud_open_mode = op;
}