// Graphical User Interface System

// Engine extensions


// Fonts
font small_font = <fontsmall.pcx>,8,8;
font critical_font = <fontcrit.pcx>,8,8;
font text_font = <textfont.pcx>,8,16;

// Resources
bmap sayuri_img = <sayuri.pcx>;
bmap wolfcoder_name_img = <wcname.pcx>;
bmap game_chill_img = <gamechill.pcx>;
bmap rmn_icon_img = <rmn.pcx>;
bmap dic_icon_img = <dic.pcx>;

// All of this shows my name to present the game
panel sayuri_icon_panel
{
	bmap = sayuri_img;
	flags = d3d,refresh,transparent,overlay;
}
panel wolfcoder_name_panel
{
	bmap = wolfcoder_name_img;
	flags = d3d,refresh,transparent,overlay;
}
function gui_presents(dist)
{
	var xx;
	var yy;
	// Off?
	if(dist == 0)
	{
		// Turn off the panels
		sayuri_icon_panel.visible = off;
		wolfcoder_name_panel.visible = off;
		return;
	}
	// Move
	xx = screen_size.x/2;
	yy = screen_size.y/2;
	wolfcoder_name_panel.pos_x = xx-32*video_scale;
	wolfcoder_name_panel.pos_y = yy-(4*video_scale)*(dist/100);
	sayuri_icon_panel.pos_y = yy-8*video_scale;
	sayuri_icon_panel.pos_x = xx-32*video_scale-16*video_scale;
	// Change
	dist = max(0,min(100,dist));
	// Show
	sayuri_icon_panel.visible = on;
	wolfcoder_name_panel.visible = on;
	// Set alpha
	sayuri_icon_panel.alpha = dist;
	wolfcoder_name_panel.alpha = dist;
	// Set scaling
	wolfcoder_name_panel.scale_y = (dist/100)*video_scale;
	wolfcoder_name_panel.scale_x = video_scale;
	sayuri_icon_panel.scale_x = video_scale;
	sayuri_icon_panel.scale_y = video_scale;
}

// All of these line the boot screen to add extra info
panel game_chill_panel
{
	bmap = game_chill_img;
	flags = d3d,refresh,transparent,overlay;
}
function gui_info(dist)
{
	// Vanish
	if(dist <= 0)
	{
		game_chill_panel.visible = off;
		return;
	}
	// Scale
	game_chill_panel.scale_x = video_scale;
	game_chill_panel.scale_y = video_scale;
	// Move
	game_chill_panel.pos_x = 0;
	game_chill_panel.pos_y = screen_size.y-8*video_scale;
	// Show
	game_chill_panel.visible = on;
	game_chill_panel.alpha = dist;
}