// Special effect

// Defines
define drop_shadow_depth = 180;

// Resources
bmap drop_shadow_img = <dropshadow.tga>;

// Makes bright
function effect_make_bright()
{
	// Trans
	my.transparent = on;
	my.alpha = 100;
	// Set bright white
	my.unlit = on;
	my.red = 255;
	my.green = 255;
	my.blue = 255;
	my.light = on;
	my.lightrange = 0;
}

// Drops the shadow
function effect_drop_shadow_action()
{
	// Set
	my.parent_ent = you;
	// I'm immediatly passable and transient. It's my job to just mimick the floor.
	my.passable = on;
	my.transparent = on;
	my.alpha = 80;
	// I actually am a floor decal that moves with the user
	my.facing = off;
	my.oriented = on;
	my.pan = 0;
	my.tilt = 90;
	my.roll = 0;
	// While myself and you are active..
	while(my != null && you != null)
	{
		// Move to player position
		my.x = you.x;
		my.y = you.y;
		my.z = you.z-16;
		// Fire a beam
		temp.x = my.x;
		temp.y = my.y;
		temp.z = my.z-drop_shadow_depth;
		c_trace(my.x,temp.x,IGNORE_YOU|IGNORE_ME|IGNORE_SPRITES);
		my.z -= result; // Move it there
		my.z += 0.05; // Get rid of that sorting beating effect
		// Invisible?
		if(result == 0)
		{
			// No shadows because no floor is underneath
			my.invisible = on;
		}
		else
		{
			// Shadow because floor is visible
			my.invisible = off;
			// Modify alpha parameters
			my.alpha = 80*(1-(result/drop_shadow_depth));
			my.scale_x = 0.05+(1-(result/drop_shadow_depth));
			my.scale_y = my.scale_x;
			my.scale_z = my.scale_x;
			// Calculate
			vec_to_angle(temp_ang,normal);
			my.pan = temp_ang.pan;
			my.tilt = temp_ang.tilt;
		}
		// Reload parent
		you = my.parent_ent;
		// Wait
		wait(1);
	}
	// Destroy myself too
	ent_remove(me);
}
function effect_drop_shadow()
{
	// Create
	ent_create("dropshadow.tga",my.x,effect_drop_shadow_action);
}