// Debug script - tests the game's systems

// Script extend
dllfunction log_open();

// Shot number
var debug_shot_num = 1;

// Positions
var team_a_1_pos[3] = -640,640,-64;
var team_a_2_pos[3] = -640,256,-64;
var team_b_1_pos[3] = 0,-640,-64;
var team_b_2_pos[3] = 640,-128,-64;

// Catch-all
function debug_autofight()
{
	while(my != null)
	{
		weapon_npc_move(my.attack_skill);
		waitt(8+random(8));
	}
}
function debug_combatant()
{
	debug_autofight();
	while(my != null)
	{
		temp.x = (3+stat_move(my.build)/1.45)/2;
		temp.y = 0;
		temp.z = 0;
		temp_ang.pan = random(360);
		temp_ang.tilt = 0;
		temp_ang.roll = 0;
		vec_rotate(temp,temp_ang);
		my.motor_x = temp.x;
		my.motor_y = temp.y;
		waitt(16+random(16));
	}
}

// Brown and gray
function brown_gray_team()
{
	my.colors = 0;
	// Combatant
	debug_combatant();
	// Team A
	if(character_selected == REN || character_selected == HIKARI)
	{
		// I'm on your side
		character_friendly();
	}
	else
	{
		// I'm your enemy
		character_enemy();
	}
}

// White and blue
function white_blue_team()
{
	my.colors = 1;
	// Combatant
	debug_combatant();
	// Team B
	if(character_selected == NAOMI || character_selected == SARAH)
	{
		// I'm on your side
		character_friendly();
	}
	else
	{
		// I'm your enemy
		character_enemy();
	}
}

// Enemies
function anti_ren()
{
	// Anti ren
	brown_gray_team();
	weapon_assign_build(ren_build,1);
	my.weapon = ren_blade;
	my.attack_skill = ren_slash;
}
function anti_hikari()
{
	// Anti ren
	brown_gray_team();
	weapon_assign_build(hikari_build,1);
	my.weapon = hikari_scroll;
	my.attack_skill = hikari_fire;
}
function anti_naomi()
{
	// Anti ren
	white_blue_team();
	weapon_assign_build(naomi_build,1);
	my.weapon = naomi_bow;
	my.attack_skill = naomi_shoot;
}

function anti_sarah()
{
	// Anti ren
	my.winged = 1;
	white_blue_team();
	weapon_assign_build(sarah_build,1);
	my.weapon = sarah_hands;
	my.attack_skill = sarah_bomb;
}

// Waves
function wave_t_wolf(&pos,&add)
{
	var poly;
	var poly_pos[3];
	vec_set(poly_pos,pos);
	vec_add(poly_pos,add);
	while(poly < 3){ent_create("eren+21.pcx",poly_pos,anti_ren);poly_pos.x += 48;poly += 1;}
	poly_pos.x -= 48*2;
	poly_pos.y += 48;
	ent_create("ehikari+21.pcx",poly_pos,anti_hikari);
}
function wave_t_cat(&pos,&add)
{
	var poly;
	var poly_pos[3];
	vec_set(poly_pos,pos);
	vec_add(poly_pos,add);
	while(poly < 3){ent_create("enaomi+21.pcx",poly_pos,anti_naomi);poly_pos.x += 48;poly += 1;}
	poly_pos.x -= 48*2;
	poly_pos.y -= 48;
	ent_create("esarah+21.pcx",poly_pos,anti_sarah);
}

// Starts debug
function debug_start()
{
	// Log
	log_open();
	// Load the sample level
	gui_hud_open(1);
	//stat_apply_selected_character(character_selected);
	level_load("weaponbirth.wmb");
	wait(1);
	ent_create("ren+21.pcx",nullvector,player_action);
	// Alright, set start! Make an array of three rens and led by one hikari
	wave_t_wolf(team_a_1_pos,vector(0,0,0));
	wave_t_wolf(team_a_1_pos,vector(192,0,0));
	// And battalions of the other side
	wave_t_cat(team_b_1_pos,vector(0,0,0));
	wave_t_cat(team_b_1_pos,vector(192,0,0));
	// Now run the battle
	while(1)
	{
		temp.x = random(1200)-600;
		temp.y = random(1200)-600;
		temp.z = -64;
		ent_create("eren+21.pcx",temp,anti_ren);
		temp.x = random(1200)-600;
		temp.y = random(1200)-600;
		temp.z = -64;
		ent_create("ehikari+21.pcx",temp,anti_hikari);
		temp.x = random(1200)-600;
		temp.y = random(1200)-600;
		temp.z = -64;
		ent_create("enaomi+21.pcx",temp,anti_naomi);
		temp.x = random(1200)-600;
		temp.y = random(1200)-600;
		temp.z = -64;
		ent_create("esarah+21.pcx",temp,anti_sarah);
		waitt(64);
	}
}

// Allows the nine key to take screens
function debug_snapshots()
{
	// Loop
	while(1)
	{
		// Respond
		if(key_9 == 1)
		{
			// Shoot
			file_for_screen("shot.bmp",debug_shot_num);
			debug_shot_num += 1;
		}
		// Wait
		while(key_9 == 1){wait(1);}
		// End
		wait(1);
	}
}