// Character system

// Character directions
define FACE_UP = 0;
define FACE_RIGHT = 1;
define FACE_DOWN = 2;
define FACE_LEFT = 3;

// Character animation indexes
define WALKING = 0;
define JUMPING = 1;
define DOWNED = 2;
define STANCED = 3;

// Attached wings
function char_attach_wings()
{
	// Appearence
	my.passable = on;
	my.nofilter = on;
	my.oriented = off;
	my.facing = on;
	// Move
	while(my != null && you != null)
	{
		// Attach
		vec_set(my.x,you.x);
		// Invisible unless you are jumping
		if(you.animation_mode != JUMPING)
		{
			my.invisible = on;
		}
		else
		{
			my.invisible = off;
		}
		// Match frames
		if(you.animation_face == 8)
		{
			my.frame = 5;
			my.y -= 4;
		}
		if(you.animation_face == 2)
		{
			my.frame = 1;
			my.y += 4;
		}
		if(you.animation_face == 5)
		{
			my.frame = 3;
			my.y += 4;
		}
		// Falling?
		if(you.move_g < 0)
		{
			my.frame += 1;
		}
		// Set
		my.scale_x = you.scale_x;
		my.scale_y = you.scale_y;
		my.scale_z = you.scale_z;
		// Hold
		wait(1);
	}
}

// Morph character selection function
function char_use_player_character(ix)
{
	// Ren?
	if(ix == REN)
	{
		ent_morph(me,"ren+21.pcx");
		return;
	}
	// Hikari?
	if(ix == HIKARI)
	{
		ent_morph(me,"hikari+21.pcx");
		return;
	}
	// Naomi?
	if(ix == NAOMI)
	{
		ent_morph(me,"naomi+21.pcx");
		return;
	}
	// Sarah?
	if(ix == SARAH)
	{
		ent_morph(me,"sarah+21.pcx");
		return;
	}
}

// Look like a sprite
function char_style()
{
	// Always look at the camera
	my.oriented = off;
	my.facing = on;
	my.combatant = 1;
	// Set trans for alpha edge blurring
	my.nofilter = on;
	// Initially walking
	my.animation_mode = WALKING;
	// Double size
	my.scale_x = 2;
	my.scale_y = 2;
	my.scale_z = 2;
	// Initially at camera?
	my.animation_direction = FACE_DOWN;
	// Put wings on em'
	if(my.winged == 1)
	{
		// Create
		ent_create("wings+6.pcx",my.x,char_attach_wings);
	}
	// Immediatly face
	char_face(my.animation_direction);
	// Attach movement
	move_handle();
	// Drop a shadow to let the player perceive our height
	effect_drop_shadow();
	character_animate();
}

// Face a direction
function char_face(f)
{
	// Set
	my.aim = f;
	// Use the bases
	if(f == FACE_UP)
	{
		my.scale_x = 2;
		my.animation_face = 8;
		return;
	}
	if(f == FACE_DOWN)
	{
		my.scale_x = 2;
		my.animation_face = 2;
		return;
	}
	if(f == FACE_RIGHT)
	{
		my.scale_x = 2;
		my.animation_face = 5;
		return;
	}
	if(f == FACE_LEFT)
	{
		my.scale_x = -2;
		my.animation_face = 5;
		return;
	}
}

// Allows the character to jump
function character_control_jump()
{
	// Wait for it
	while(my != null)
	{
		// Doesn't even do anything if being owned
		if(my.pwned <= 0)
		{
			// Return to home state?
			if(my.landed == 1 && my.animation_mode != WALKING)
			{
				// Reset
				my.animation_mode = WALKING;
			}
			// Suddenly falling?
			if(my.landed == 0 && my.animation_mode == WALKING)
			{
				// Set falling
				my.animation_mode = JUMPING;
			}
			// Attacking
			if(my.attacking == 1)
			{
				my.animation_mode = STANCED;
			}
			// Apply jumps
			if(key_c == 1)
			{
				// Jump
				my.jump = 12;
				// Flag jumping
				my.animation_mode = JUMPING;
			}
			// Wait for the player to let go.
			while(key_c == 1){wait(1);}
		}
		else
		{
			// Fall damage is related to jumping, so handle it here
			if(my.animation_mode != DOWNED)
			{
				my.animation_mode = DOWNED;
			}
			// The player needs to wait a short moment to shake it off
			my.pwned -= time_step*1.75;
			// Go back to walking
			if(my.pwned <= 0)
			{
				my.animation_mode = WALKING;
			}
		}
		// Reset
		wait(1);
	}
}

// Allows the character to be under control
function character_control()
{
	// Wait for it
	while(my != null)
	{
		// Don't do anything if we're in the air, how are you supposed to move if you're in the air?
		// Stand still if attacking
		if(my.attacking == 1 && my.landed == 1)
		{
			my.move_x = 0;
			my.move_y = 0;
		}
		// Also, if we're currently getting owned we can't move
		if((my.landed == 1 || my.winged == 1) && my.pwned <= 0 && my.attacking != 1 && my.health > 0)
		{
			// Apply movement values
			my.move_x = key_force.x*(3+stat_move(character_selected)/1.45);
			my.move_y = key_force.y*(3+stat_move(character_selected)/1.45);
			// Apply directions
			if(key_force.x > 0)
			{
				char_face(FACE_RIGHT);
			}
			if(key_force.x < 0)
			{
				char_face(FACE_LEFT);
			}
			if(key_force.y > 0)
			{
				char_face(FACE_UP);
			}
			if(key_force.y < 0)
			{
				char_face(FACE_DOWN);
			}
			// If we are moving, walking animation?
			if(key_force.x != 0 || key_force.y != 0)
			{
				// Advance
				my.animation_dist += 3*time_step;
			}
		}
		// End
		wait(1);
	}
}

// Animate the character
function character_animate()
{
	// Animate
	while(my != null)
	{
		// Attacking stance
		if(my.animation_mode == STANCED)
		{
			// HAH!
			if(my.animation_face == 2)
			{
				my.frame = 19;
			}
			if(my.animation_face == 5)
			{
				my.frame = 20;
			}
			if(my.animation_face == 8)
			{
				my.frame = 21;
			}
		}
		// Getting pwned
		if(my.animation_mode == DOWNED)
		{
			// OUCH!!
			if(my.landed != 1)
			{
				// Haven't hit the ground yet
				my.frame = 18;
			}
			else
			{
				// On ground
				my.frame = 16;
			}
			// Getting up...
			if(my.pwned < 8)
			{
				my.frame = 17;
			}
		}
		// Jumping
		if(my.animation_mode == JUMPING)
		{
			// Recode frames
			if(my.animation_face == 2)
			{
				my.frame = 10;
			}
			if(my.animation_face == 5)
			{
				my.frame = 12;
			}
			if(my.animation_face == 8)
			{
				my.frame = 14;
			}
			// Falling frames?
			if(my.move_g < 0) // Going down?
			{
				my.frame += 1;
			}
		}
		// Walking
		if(my.animation_mode == WALKING)
		{
			// Put frames
			my.frame = my.animation_face;
			// Add the dist
			if(my.animation_dist > 8)
			{
				my.frame += 1;
			}
			// Reset the dist
			if(my.animation_dist > 16)
			{
				my.frame -= 1;
			}
			// Subtract the dist
			if(my.animation_dist > 24)
			{
				my.frame -= 1;
			}
		}
		// Always reset the dist if greater
		if(my.animation_dist >= 32)
		{
			// Reset
			my.animation_dist = 0;
		}
		// End
		wait(1);
	}
}

// NPC
function character_npc()
{
	// Enter
	while(1)
	{
		// Negate motors
		if(my.pwned > 0 || my.health < 0)
		{
			my.motor_x = 0;
			my.motor_y = 0;
			my.motor_z = 0;
		}
		// Handle falling and jumping animation
		if(my.landed != 1 && my.animation_mode == WALKING)
		{
			my.animation_mode = JUMPING;
		}
		if(my.landed == 1 && my.animation_mode == JUMPING)
		{
			my.animation_mode = WALKING;
		}
		// Handle attacking
		if(my.attacking == 1 && my.animation_mode != DOWNED)
		{
			my.animation_mode = STANCED;
		}
		else
		{
			if(my.animation_mode == STANCED)
			{
				my.animation_mode = WALKING;
			}
		}
		// Allow facing and moving only if not falling
		if(my.landed == 1)
		{
			// Copy motors
			my.move_x = my.motor_x;
			my.move_y = my.motor_y;
			my.move_z = my.motor_z;
			// Walk according to move
			temp.x = my.move_x;
			temp.y = my.move_y;
			temp.z = my.move_z;
			if(my.motor_x != 0 || my.motor_y != 0)
			{	
				my.animation_dist += 3*time_step;
			}
			// Face according to face
			if(abs(my.move_x) > abs(my.move_y))
			{
				if(my.move_x < 0)
				{
					char_face(FACE_LEFT);
				}
				if(my.move_x > 0)
				{
					char_face(FACE_RIGHT);
				}
			}
			else
			{
				if(my.move_y < 0)
				{
					char_face(FACE_DOWN);
				}
				if(my.move_y > 0)
				{
					char_face(FACE_UP);
				}
			}
		}
		// End
		wait(1);
	}
}

// Facer
function character_match_face_angle(cod)
{
	// Convert code
	if(cod == FACE_UP)
	{
		return(90);
	}
	if(cod == FACE_RIGHT)
	{
		return(0);
	}
	if(cod == FACE_DOWN)
	{
		return(270);
	}
	if(cod == FACE_LEFT)
	{
		return(180);
	}
	// No code?
	return(0);
}