// Resources
var slot_window_icon_val = 0;
bmap slot_window_img = <slotwindow.pcx>;
bmap char_icon_img = <charicon.pcx>;
bmap weapon_icon_img = <staticon.pcx>,0,0,24,8;
bmap ether_icon_img = <staticon.pcx>,0,8,24,8;
bmap skill_icon_img = <staticon.pcx>,0,16,24,8;
bmap critical_icon_img = <staticon.pcx>,0,32,24,8;
bmap move_icon_img = <staticon.pcx>,0,40,24,8;
bmap res_icon_img = <staticon.pcx>,0,24,24,8;
bmap vital_plate_img = <vitplate.pcx>;

// Shows the character status card
panel stat_window_panel
{
	bmap = slot_window_img;
	flags = d3d,refresh,overlay,transparent;
	alpha = 100;
	layer = 5;
}
text stat_window_name_text
{
	font = small_font;
	flags = d3d,transparent;
	alpha = 100;
	layer = 6;
}
panel stat_window_char_panel
{
	window = 0,0,16,16,char_icon_img,slot_window_icon_val,0;
	flags = d3d,refresh,overlay,transparent;
	alpha = 100;
	layer = 6;
}
var stat_maxhp_num_mirror;
var stat_maxep_num_mirror;
panel stat_hpmax_panel
{
	button = 2,2,vital_plate_img,vital_plate_img,vital_plate_img,null,null,null;
	button = 0,0,hp_label_img,hp_label_img,hp_label_img,null,null,null;
	button = 56,0,ep_label_img,ep_label_img,ep_label_img,null,null,null;
	digits = 24,0,3,small_font,1,stat_maxhp_num_mirror;
	digits = 80,0,3,small_font,1,stat_maxep_num_mirror;
	flags = d3d,refresh,overlay,transparent;
	alpha = 100;
	layer = 6;
}
var stat_weapon_mirror;
var stat_ether_mirror;
var stat_skill_mirror;
var stat_critical_mirror;
var stat_move_mirror;
var stat_res_mirror;
panel stat_basic_panel
{
	button = 0,0,weapon_icon_img,weapon_icon_img,weapon_icon_img,null,null,null;
	digits = 16,6,3,small_font,1,stat_weapon_mirror;
	button = 40,0,ether_icon_img,ether_icon_img,ether_icon_img,null,null,null;
	digits = 56,6,3,small_font,1,stat_ether_mirror;
	button = 80,0,skill_icon_img,skill_icon_img,skill_icon_img,null,null,null;
	digits = 96,6,3,small_font,1,stat_skill_mirror;
	button = 0,16,critical_icon_img,critical_icon_img,critical_icon_img,null,null,null;
	digits = 16,22,3,small_font,1,stat_critical_mirror;
	button = 40,16,move_icon_img,move_icon_img,move_icon_img,null,null,null;
	digits = 56,22,3,small_font,1,stat_move_mirror;
	button = 80,16,res_icon_img,res_icon_img,res_icon_img,null,null,null;
	digits = 96,22,3,small_font,1,stat_res_mirror;
	flags = d3d,refresh,overlay,transparent;
	alpha = 100;
	layer = 6;
}
function stat_window_show(xx,yy,dd)
{
	// Vanish
	if(dd == 0)
	{
		stat_window_panel.visible = off;
		stat_window_name_text.visible = off;
		stat_window_char_panel.visible = off;
		stat_hpmax_panel.visible = off;
		stat_basic_panel.visible = off;
		return;
	}
	// Set name
	if(character_selected == REN){stat_window_name_text.string = "Ren";}
	if(character_selected == HIKARI){stat_window_name_text.string = "Hikari";}
	if(character_selected == NAOMI){stat_window_name_text.string = "Naomi";}
	if(character_selected == SARAH){stat_window_name_text.string = "Sarah";}
	// Copy stats
	stat_maxhp_num_mirror = stat_maxhp(character_selected,lvl);
	stat_maxep_num_mirror = stat_maxep(character_selected,lvl);
	stat_weapon_mirror = stat_weaponry(character_selected,lvl);
	stat_ether_mirror = stat_ether(character_selected,lvl);
	stat_skill_mirror = stat_skill(character_selected,lvl);
	stat_res_mirror = stat_resistance(character_selected,lvl);
	stat_critical_mirror = stat_critical(character_selected);
	stat_move_mirror = stat_move(character_selected);
	// Set icon
	slot_window_icon_val = character_selected*16;
	// Move
	stat_window_panel.pos_x = xx;
	stat_window_panel.pos_y = yy;
	stat_window_name_text.pos_x = xx+(8+32)*video_scale;
	stat_window_name_text.pos_y = yy+8*video_scale;
	stat_window_char_panel.pos_x = xx+12*video_scale;
	stat_window_char_panel.pos_y = yy+12*video_scale;
	stat_hpmax_panel.pos_x = xx+(8+32)*video_scale;
	stat_hpmax_panel.pos_y = yy+24*video_scale;
	stat_basic_panel.pos_x = xx+(8+24+32+88)*video_scale;
	stat_basic_panel.pos_y = yy+(8-3)*video_scale;
	// Scale
	stat_window_panel.scale_x = video_scale;
	stat_window_panel.scale_y = video_scale;
	stat_window_name_text.scale_x = video_scale;
	stat_window_name_text.scale_y = video_scale;
	stat_window_char_panel.scale_x = video_scale;
	stat_window_char_panel.scale_y = video_scale;
	stat_hpmax_panel.scale_x = video_scale;
	stat_hpmax_panel.scale_y = video_scale;
	stat_basic_panel.scale_x = video_scale;
	stat_basic_panel.scale_y = video_scale;
	// On
	stat_window_panel.visible = on;
	stat_window_name_text.visible = on;
	stat_window_char_panel.visible = on;
	stat_hpmax_panel.visible = on;
	stat_basic_panel.visible = on;
}

// Handles the card
var show_card_mode;
var show_card_pos;
var diff_char_select;
function stat_card_handle()
{
	show_card_pos = screen_size.y;
	diff_char_select = character_selected;
	while(1)
	{
		// Difference?
		if(diff_char_select != character_selected)
		{
			// Change character
			diff_char_select = character_selected;
			show_card_pos = screen_size.y;
		}
		// Move on and off screen
		if(show_card_mode == 0)
		{
			// Slide off
			if(show_card_pos < screen_size.y)
			{
				show_card_pos += time_step*45;
			}
			else
			{
				show_card_pos = screen_size.y;
			}
		}
		else
		{
			// Slide on
			if(show_card_pos > screen_size.y-48*video_scale)
			{
				show_card_pos -= time_step*45;
			}
			else
			{
				show_card_pos = screen_size.y-48*video_scale;
			}
		}
		// Mod
		stat_window_show(screen_size.x/2-(280*video_scale)/2,show_card_pos,100);
		wait(1);
	}
}

// Shows the card
function stat_card_show(md)
{
	// Set
	show_card_mode = md;
}