// Camera system

// Follow this entity
entity* camera_targ;
var camera_targ_pos[3] = 0,0,0;
var camera_cur[3] = 0,0,0;
var zoom = 450;

// Handle the camera
function camera_handle()
{
	// Enter loop
	while(1)
	{
		// Hit entity?
		if(camera_targ != null)
		{
			// Set vector target
			vec_set(camera_targ_pos.x,camera_targ.x);
			// Release the focus if dead
			if(camera_targ.health <= 0)
			{
				camera_targ = null;
			}
		}
		// Move camera there
		camera_cur.x += ((camera_targ_pos.x-camera_cur.x)/4)*time_step;
		camera_cur.y += ((camera_targ_pos.y-camera_cur.y)/4)*time_step;
		camera_cur.z += ((camera_targ_pos.z-camera_cur.z)/4)*time_step;
		// Update camera
		camera.x = camera_cur.x;
		camera.y = camera_cur.y-zoom;
		camera.z = camera_cur.z+zoom/2;
		camera.tilt = -25;
		camera.pan = 90;
		camera.roll = 0;
		// End loop
		wait(1);
	}
}

// Cameras focus
function camera_focus(ent)
{
	// Valid target
	camera_targ = ent;
}