#ifndef VIDEO_H
#define VIDEO_H

/* Display Status */
#define DISPSTAT *((vu16*)0x04000004)
/* Display Control */
#define DISPCNT *((vu16*)0x04000000)

/* Background controls */
#define BG0_CNT *((vu16*)0x04000008)
#define BG1_CNT *((vu16*)0x0400000A)
#define BG2_CNT *((vu16*)0x0400000C)
#define BG3_CNT *((vu16*)0x0400000E)

/* Background bases */
#define BG_BASE ((vu16*)0x0600C000)
#define BG0_BASE *((vu16*)0x0600C000)
#define BG1_BASE *((vu16*)0x0600C800)
#define BG2_BASE *((vu16*)0x0600D000)
#define BG3_BASE *((vu16*)0x0600D800)

/* Base of VRAM */
#define VRAM ((u8*)0x06000000)

/* Base of palettes */
#define VPAL ((u16*)0x05000000)

/* NFI types */
#define NFI_16 0
#define NFI_256 1
#define NFI_COLOR 2

/* NFI (NovaForce Image) Header */
typedef struct
{
	u32 type; /* Type of image */
	u32 width; /* Size (in blocks) of data */
	u32 height;
	u32 fwidth; /* Width and height of each frame */
	u32 fheight;
	u32 fsize; /* Number of blocks in each frame */
}nfi_header;

/*
	This function handles video stuff every frame.
	It's supposed to be called every frame.
*/
extern void video_wait();

/*
	Erases ALL video memory and resets video settings.
*/
extern void video_wipe();

/*
	Enters the typical mapping mode.
*/
extern void video_init();

/*
	Loads an image into VRAM+voff from the source pointer given.
	The source pointer must point to the beginning of an NFI formatted image.
	poff is the palette set (of 16 colors in each set) to use for the palette.
	plen is the number of colors in a 256-color image to actually load.
*/
extern void video_image_load(u32 voff,u32 poff,u32 plen,void *imgsrc);

/*
	Loads a tileset into VRAM along with its palette into background palettes.
	Only one tileset may be loaded at one time.
*/
extern void video_tileset_load(void *imgsrc);

#endif
