package nftile;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;

import javax.swing.JFrame;

import nf.ErrorBox;
import nf.StatusBar;
import nfimage.BlockImage;

public class TileWindow extends JFrame
{
	private static final long serialVersionUID = 1L;
	private boolean directMode;
	private TilePanel tilePanel;
	private TileMenu tileMenu;
	private StatusBar statusBar;
	private String indirectFile;
	//private TransPanel transPanel;
	private class TileAdapter extends WindowAdapter
	{
		@Override
		public void windowClosing(WindowEvent e)
		{
			// End program
			close();
		}
		@Override
		public void windowClosed(WindowEvent e)
		{
			// Auto save
			if(!directMode)
			{
				try
				{
					tilePanel.getFocus().save(indirectFile);
				}
				catch(IOException ee)
				{
					ErrorBox.show("Failed to save "+indirectFile);
				}
				System.out.println("Saved: "+indirectFile);
			}
			// Direct?
			if(directMode)
				System.exit(0);
		}
	}
	public TileWindow(boolean direct)
	{
		// Title
		super("Tileset Editor");
		// Ops
		directMode = direct;
		// Properties
		setLayout(new BorderLayout());
		addWindowListener(new TileAdapter());
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		// Build
		tileMenu = new TileMenu(direct);
		getContentPane().add(tileMenu,BorderLayout.NORTH);
		//transPanel = new TransPanel();
		tilePanel = new TilePanel(this);
		getContentPane().add(tilePanel,BorderLayout.CENTER);
		statusBar = new StatusBar("Import a .NFI file to begin.");
		getContentPane().add(statusBar,BorderLayout.SOUTH);
		//getContentPane().add(transPanel,BorderLayout.SOUTH);
		pack();
	}
	public void open()
	{
		setLocationRelativeTo(null);
		setVisible(true);
	}
	public void close()
	{
		// Dispose
		dispose();
	}
	public void setIndirectFile(String fn)
	{
		indirectFile = fn;
	}
	public void setClip(BlockImage bi)
	{
		tilePanel.setClip(bi);
	}
	public void focus(Tileset ts)
	{
		tilePanel.focus(ts);
		//transPanel.setColor(ts.getTransparentColor());
	}
	public void setStatus(String s)
	{
		// Set here
		statusBar.setText(s);
	}
	public void setEditMode(int em)
	{
		// Pass
		tilePanel.setEditMode(em);
	}
}