package nftile;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class TileMenu extends JMenuBar
{
	private static final long serialVersionUID = 1L;
	private JMenu fileMenu;
	private JMenu editMenu;
	private ExitCommand exitCommand = new ExitCommand();
	private ImportCommand importCommand = new ImportCommand();
	private SaveCommand saveCommand = new SaveCommand();
	private OpenCommand openCommand = new OpenCommand();
	private DeleteCommand deleteCommand = new DeleteCommand();
	private PassCommand passCommand = new PassCommand();
	private LevelCommand levelCommand = new LevelCommand();
	//private Color128Command color128Command = new Color128Command();
	//private Color256Command color256Command = new Color256Command();
	public TileMenu(boolean direct)
	{
		// Build
		fileMenu = new JMenu("File");
		fileMenu.add(importCommand.makeMenuItem());
		if(direct)
		{
			fileMenu.add(openCommand.makeMenuItem());
			fileMenu.add(saveCommand.makeMenuItem());
		}
		fileMenu.addSeparator();
		fileMenu.add(exitCommand.makeMenuItem());
		editMenu = new JMenu("Edit");
		editMenu.add(deleteCommand.makeMenuItem());
		editMenu.add(levelCommand.makeMenuItem());
		editMenu.add(passCommand.makeMenuItem());
		//colorMenu.add(color128Command.makeMenuItem());
		//colorMenu.add(color256Command.makeMenuItem());
		add(fileMenu);
		add(editMenu);
	}
}