package nftile;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;

public class SaveCommand extends TileCommand
{
	private JFileChooser chooser = new JFileChooser();
	public SaveCommand()
	{
		chooser.setFileFilter(new NovaForceTileFilter());
		chooser.setCurrentDirectory(new File(NovaForceTile.config.lastDir));
	}
	@Override
	public void run()
	{
		if(subject == null)
		{
			ErrorBox.show("There's no tileset to save.");
			return;
		}
		if(chooser.showSaveDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Save it
				subject.save(fname);
				NovaForceTile.config.setLastDirFromFile(new File(fname));
				NovaForceTile.config.save();
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not save "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Save";
	}
}