package nftile;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;

public class OpenCommand extends TileCommand
{
	private JFileChooser chooser = new JFileChooser();
	public OpenCommand()
	{
		chooser.setFileFilter(new NovaForceTileFilter());
		chooser.setCurrentDirectory(new File(NovaForceTile.config.lastDir));
	}
	@Override
	public void run()
	{
		if(subject == null)
		{
			focus(new Tileset());
			window.focus(subject);
		}
		if(chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Open it
				subject.open(fname);
				window.repaint();
				NovaForceTile.config.setLastDirFromFile(new File(fname));
				NovaForceTile.config.save();
				window.focus(subject);
				window.setStatus(chooser.getSelectedFile().getName()+" opened.");
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not open "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Open";
	}
}