package nftile;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;
import nfimage.BlockImage;
import nfimage.NovaForceImageFilter;

public class ImportCommand extends TileCommand
{
	private JFileChooser chooser = new JFileChooser();
	public ImportCommand()
	{
		chooser.setFileFilter(new NovaForceImageFilter());
		chooser.setCurrentDirectory(new File(NovaForceTile.config.lastDir));
	}
	@Override
	public void run()
	{
		// Attempt a check
		if(!subject.hasNextPalette())
		{
			ErrorBox.show("There's no more room for colors.");
			window.setStatus("You must remove a set of tiles to make room.");
			return;
		}
		if(chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Load
				BlockImage bi = new BlockImage();
				bi.open(fname);
				System.out.println("Imported "+fname);
				// Focus
				NovaForceTile.config.setLastDirFromFile(new File(fname));
				NovaForceTile.config.save();
				// We now have something loaded to clipboard
				window.setStatus("Now place it in the tileset.");
				window.setClip(bi);
				window.setEditMode(TilePanel.IMPORT_EDIT);
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not open "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Import";
	}
}