package nfmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;

import javax.swing.JFrame;
import javax.swing.JPanel;

import nftile.Tileset;

public class TilePalette extends JFrame implements MouseListener,MouseMotionListener
{
	private static final long serialVersionUID = 1L;
	private Tileset tileset;
	private TilePalettePanel tpanel = new TilePalettePanel();
	private int posX,posY,endX,endY;
	private JFrame attachedFrame;
	private int modX,modY;
	private int srcX,srcY;
	// Drawing panel
	private class TilePalettePanel extends JPanel
	{
		private static final long serialVersionUID = 1L;
		public TilePalettePanel()
		{
			setBackground(Color.BLACK);
			setPreferredSize(new Dimension(256,256));
		}
		@Override
		public void paintComponent(Graphics g)
		{
			super.paintComponent(g);
			Graphics2D g2d = (Graphics2D)g;
			if(tileset != null)
				g2d.drawRenderedImage(tileset.getImage(),AffineTransform.getTranslateInstance(0,0));
			// Draw marquee
			g.setColor(Color.WHITE);
			g.drawRect(posX*16,posY*16,15+endX*16,15+endY*16);
		}
	}
	// Make a new one
	public TilePalette()
	{
		super("Tileset");
		setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		setLayout(new BorderLayout());
		tpanel.addMouseListener(this);
		tpanel.addMouseMotionListener(this);
		getContentPane().add(tpanel,BorderLayout.CENTER);
		pack();
	}
	public void attach(JFrame at)
	{
		attachedFrame = at;
	}
	// Open the window
	public void open()
	{
		// Put on left
		if(attachedFrame != null)
			setLocation(attachedFrame.getX()-getWidth(),attachedFrame.getY());
		// Show
		setVisible(true);
	}
	// Focus on set
	public void focus(Tileset ts)
	{
		tileset = ts;
	}
	// Returns the first selected tile
	public int getSelectedTile(int ox,int oy)
	{
		return (posX+ox)*2+(posY+oy)*2*32;
	}
	public int getSelectedModTile(int ox,int oy)
	{
		// Find the offset from the x and the mod x
		ox += srcX-modX;
		oy += srcY-modY;
		ox = ox%(endX+1);
		oy = oy%(endY+1);
		if(ox < 0)
			ox = (endX+1)+ox;
		if(oy < 0)
			oy = (endY+1)+oy;
		// Then do normal
		return getSelectedTile(ox,oy);
	}
	public int getSelectedWidth()
	{
		return endX;
	}
	public int getSelectedHeight()
	{
		return endY;
	}
	// Draws a marquee of selected tiles to screen
	public void apply(TileMap tm,int x,int y,int ly)
	{
		for(int yy = 0;yy <= endY;yy++)
		{
			for(int xx = 0;xx <= endX;xx++)
			{
				tm.setTile(ly,x+xx,y+yy,getSelectedModTile(xx,yy));
			}
		}
	}
	// Sets the base modulus so marquee drawing generates tesselations and not overwrites
	public void setModTile(int mmx,int mmy)
	{
		modX = mmx;
		modY = mmy;
	}
	public void setSrcTile(int sx,int sy)
	{
		srcX = sx;
		srcY = sy;
	}
	@Override
	public void mousePressed(MouseEvent e)
	{
		posX = e.getX()/16;
		posY = e.getY()/16;
		endX = 0;
		endY = 0;
		repaint();
	}
	@Override
	public void mouseReleased(MouseEvent e){}
	@Override
	public void mouseClicked(MouseEvent e){}
	@Override
	public void mouseEntered(MouseEvent e){}
	@Override
	public void mouseExited(MouseEvent e){}
	@Override
	public void mouseMoved(MouseEvent e){}
	@Override
	public void mouseDragged(MouseEvent e)
	{
		endX = (e.getX()/16)-posX;
		endY = (e.getY()/16)-posY;
		repaint();
	}
}