package nfmap;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;

public class SaveCommand extends MapCommand
{
	private JFileChooser chooser = new JFileChooser();
	public SaveCommand()
	{
		chooser.setFileFilter(new NovaForceMapFilter());
		chooser.setCurrentDirectory(new File(NovaForceMap.config.lastDir));
	}
	@Override
	public void run()
	{
		if(subject == null)
		{
			ErrorBox.show("There's no map to save.");
			return;
		}
		if(chooser.showSaveDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Save it
				subject.save(fname);
				NovaForceMap.config.setLastDirFromFile(new File(fname));
				NovaForceMap.config.save();
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not save "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Save";
	}
}