package nfmap;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;

public class OpenCommand extends MapCommand
{
	private JFileChooser chooser = new JFileChooser();
	public OpenCommand()
	{
		chooser.setFileFilter(new NovaForceMapFilter());
		chooser.setCurrentDirectory(new File(NovaForceMap.config.lastDir));
	}
	@Override
	public void run()
	{
		if(subject == null)
		{
			focus(new TileMap());
			window.focus(subject);
		}
		if(chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Open it
				subject.open(fname);
				window.repaint();
				NovaForceMap.config.setLastDirFromFile(new File(fname));
				NovaForceMap.config.save();
				window.focus(subject);
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not open "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Open";
	}
}