package nfmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JFrame;
import javax.swing.JPanel;

import nf.NovaDraw;
import nftile.Tileset;

public class NovaForceMap extends JPanel implements MouseListener,MouseMotionListener
{
	public static MapConfig config = new MapConfig();
	public static final int LOWER_EDIT = 0;
	public static final int UPPER_EDIT = 1;
	private static final long serialVersionUID = 1L;
	private int layerMode;
	private int curX,curY;
	private TileMap tileMap;
	private Tileset tileset;
	private TilePalette tpal = new TilePalette();
	public NovaForceMap()
	{
		setBackground(Color.BLACK);
		setPreferredSize(new Dimension(500,384));
		addMouseListener(this);
		addMouseMotionListener(this);
	}
	public void attach(JFrame at)
	{
		tpal.attach(at);
	}
	public void setLayerMode(int em)
	{
		System.out.println("Layer editing mode set to "+em);
		layerMode = em;
		if(layerMode == 0)
			tileMap.setUpperShade(false);
		else
			tileMap.setUpperShade(true);
		repaint();
	}
	private void drawCursor(Graphics g,int ix,int iy,int w,int h)
	{
		ix = ix*16+1;
		iy = iy*16+1;
		w = w*16-2;
		h = h*16-2;
		g.setColor(new Color(192,255,192));
		g.drawRect(ix,iy,w+tpal.getSelectedWidth()*16,h+tpal.getSelectedHeight()*16);
	}
	public void focus(TileMap tm)
	{
		tileMap = tm;
		repaint();
	}
	public void setTileset(Tileset ts)
	{
		tileset = ts;
		tileMap.setTileset(ts);
		tpal.focus(ts);
		tpal.open();
		repaint();
	}
	public void mouseDrawn()
	{
		tpal.setSrcTile(curX,curY);
		tpal.apply(tileMap,curX,curY,layerMode);
		//tileMap.setTile(0,curX,curY,tpal.getSelectedTile(0,0));
	}
	@Override
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		Graphics2D g2d = (Graphics2D)g;
		// Draw the tilemap?
		if(tileMap != null)
			tileMap.draw(g2d);
		if(!(curX >= tileMap.getWidth() || curY >= tileMap.getHeight()))
			drawCursor(g,curX,curY,1,1);
		// Draw the tiles
		g.setColor(Color.WHITE);
		NovaDraw.drawOutlineString(g,"T:"+tileMap.getFragment(curX*2,curY*2,layerMode),8,10);
	}
	@Override
	public void mousePressed(MouseEvent e)
	{
		// Just like moving
		mouseMoved(e);
		// Set modulator
		tpal.setModTile(curX,curY);
		tpal.setSrcTile(curX,curY);
		// Just like drawing
		mouseDrawn();
	}
	@Override
	public void mouseReleased(MouseEvent e){}
	@Override
	public void mouseClicked(MouseEvent e){}
	@Override
	public void mouseEntered(MouseEvent e){}
	@Override
	public void mouseExited(MouseEvent e){}
	@Override
	public void mouseMoved(MouseEvent e)
	{
		// Get position
		curX = e.getX()/16;
		curY = e.getY()/16;
		repaint();
	}
	@Override
	public void mouseDragged(MouseEvent e)
	{
		// Just like moving
		mouseMoved(e);
		// Just like drawing
		mouseDrawn();
	}
}