package nfmap;

import java.awt.BorderLayout;

import javax.swing.JFrame;

import nf.NativeStyle;

public class NFMap extends JFrame
{
	private static final long serialVersionUID = 1L;
	private NovaForceMap novaForceMap = new NovaForceMap();
	private MapMenu mapMenu = new MapMenu();
	public NFMap()
	{
		super("Map Editor");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setLayout(new BorderLayout());
		getContentPane().add(mapMenu,BorderLayout.NORTH);
		novaForceMap.attach(this);
		getContentPane().add(novaForceMap,BorderLayout.CENTER);
		pack();
	}
	public void setLayerMode(int em)
	{
		novaForceMap.setLayerMode(em);
	}
	public NovaForceMap getMapPanel()
	{
		return novaForceMap;
	}
	public void open()
	{
		setLocationRelativeTo(null);
		setVisible(true);
	}
	public void close()
	{
		dispose();
		System.exit(0);
	}
	public void focus(TileMap tm)
	{
		novaForceMap.focus(tm);
	}
	public static void main(String[] args)
	{
		NovaForceMap.config.load();
		NativeStyle.apply();
		TileMap tm = new TileMap();
		NFMap nfmap = new NFMap();
		MapCommand.window(nfmap);
		MapCommand.focus(tm);
		nfmap.open();
		nfmap.focus(tm);
	}
}