package nfmap;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class MapMenu extends JMenuBar
{
	private static final long serialVersionUID = 1L;
	private JMenu fileMenu;
	private JMenu editMenu;
	private OpenCommand openCommand;
	private SaveCommand saveCommand;
	private ExitCommand exitCommand;
	private TilesetCommand tilesetCommand;
	private LowerCommand lowerCommand;
	private UpperCommand upperCommand;
	public MapMenu()
	{
		openCommand = new OpenCommand();
		saveCommand = new SaveCommand();
		exitCommand = new ExitCommand();
		lowerCommand = new LowerCommand();
		upperCommand = new UpperCommand();
		tilesetCommand = new TilesetCommand();
		fileMenu = new JMenu("File");
		fileMenu.add(openCommand.makeMenuItem());
		fileMenu.add(saveCommand.makeMenuItem());
		fileMenu.addSeparator();
		fileMenu.add(exitCommand.makeMenuItem());
		editMenu = new JMenu("Edit");
		editMenu.add(tilesetCommand.makeMenuItem());
		editMenu.addSeparator();
		editMenu.add(lowerCommand.makeMenuItem());
		editMenu.add(upperCommand.makeMenuItem());
		add(fileMenu);
		add(editMenu);
	}
}