import java.awt.Color;
import java.io.IOException;

import nfimage.BlockImage;

import org.junit.Assert;
import org.junit.Test;

public class BlockImageTest
{
	@Test
	public void testBlockImage16() throws IOException
	{
		BlockImage bi = new BlockImage("test16.bmp");
		Assert.assertEquals(bi.getWidth(),64);
		Assert.assertEquals(bi.getHeight(),64);
		Color c16 = bi.getPixel(9,12);
		Assert.assertTrue(c16.getRed() > c16.getBlue());
		Assert.assertTrue(c16.getGreen() > c16.getBlue());
	}
	@Test
	public void testBlockImage256() throws IOException
	{
		BlockImage bi = new BlockImage("test256.bmp");
		Assert.assertEquals(bi.getWidth(),80);
		Assert.assertEquals(bi.getHeight(),128);
		Color c256 = bi.getPixel(13,29);
		Assert.assertTrue(c256.getBlue() > c256.getRed());
		Assert.assertTrue(c256.getBlue() > c256.getGreen());
	}
	@Test
	public void testBlockImageFull() throws IOException
	{
		BlockImage bi = new BlockImage("test.bmp");
		Assert.assertEquals(bi.getWidth(),80);
		Assert.assertEquals(bi.getHeight(),80);
		Color c = bi.getPixel(24,18);
		Assert.assertTrue(c.getBlue() > c.getRed());
	}
}