package nfimage;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransPanel extends JPanel
{
	private static final long serialVersionUID = 1L;
	private TransColorPanel transColorPanel = new TransColorPanel();
	// The color panel that shows the current transparent color
	private class TransColorPanel extends JPanel
	{
		private static final long serialVersionUID = 1L;
		public TransColorPanel()
		{
			// Just a rectangle of color, really
			setPreferredSize(new Dimension(80,16));
			setBackground(Color.BLACK);
		}
		public void setColor(Color c)
		{
			// Set and refresh
			setBackground(c);
			repaint();
		}
	}
	public TransPanel()
	{
		// Build it
		setLayout(new BorderLayout());
		add(new JLabel("Transparent Color:"),BorderLayout.WEST);
		add(transColorPanel,BorderLayout.EAST);
	}
	public void setColor(Color c)
	{
		// Set and refresh
		System.out.println("Transparent color: "+c);
		transColorPanel.setColor(c);
		repaint();
	}
}