package nfimage;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;

public class SaveCommand extends ImageCommand
{
	private JFileChooser chooser = new JFileChooser();
	public SaveCommand()
	{
		chooser.setFileFilter(new NovaForceImageFilter());
		chooser.setCurrentDirectory(new File(NovaForceImage.config.lastDir));
	}
	@Override
	public void run()
	{
		// Set from auto file
		chooser.setSelectedFile(new File(autoFile));
		if(subject == null)
		{
			ErrorBox.show("There's no image to save.");
			return;
		}
		if(chooser.showSaveDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Save it
				subject.save(fname);
				NovaForceImage.config.setLastDirFromFile(new File(fname));
				NovaForceImage.config.save();
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not save "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Save";
	}
}