package nfimage;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * Holds a single palette color entry.
 * @author Sayuri
 */
public class PaletteEntry
{
	public int r,g,b;
	/**
	 * Reads the following palette entry from the input stream.
	 * @param dis Source stream
	 * @throws IOException
	 */
	public PaletteEntry(DataInputStream dis) throws IOException
	{
		// Read it
		b = dis.readUnsignedByte();
		g = dis.readUnsignedByte();
		r = dis.readUnsignedByte();
		dis.readUnsignedByte();
	}
	public PaletteEntry()
	{
		r = 0;
		g = 0;
		b = 0;
	}
	/**
	 * Returns the color of this palette entry.
	 * @return The color matching this entry
	 */
	public Color makeColor()
	{
		// Make
		return new Color(r,g,b);
	}
	public static void write(DataOutputStream dos,PaletteEntry p) throws IOException
	{
		// Null?
		if(p == null)
		{
			dos.writeByte(0);
			dos.writeByte(0);
			return;
		}
		// Divide into components
		int r16 = p.r/8;
		int g16 = p.g/8;
		int b16 = p.b/8;
		// Build
		g16 = g16<<5;
		b16 = b16<<10;
		int accu = r16|g16|b16;
		// Write
		dos.writeByte((byte)accu);
		dos.writeByte((byte)(accu>>>8));
	}
	public static PaletteEntry read(DataInputStream dis) throws IOException
	{
		PaletteEntry p = new PaletteEntry();
		// Read it
		int accu = dis.readByte()&0xFF;
		accu += (dis.readByte()&0xFF)<<8;
		// Cut it
		int r16 = accu&31;
		accu = accu>>>5;
		int g16 = accu&31;
		accu = accu>>>5;
		int b16 = accu&31;
		// Increase
		r16 = r16*8;
		g16 = g16*8;
		b16 = b16*8;
		// Build
		p.r = r16;
		p.g = g16;
		p.b = b16;
		// Return
		return p;
	}
}