package nfimage;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;

public class OpenCommand extends ImageCommand
{
	private JFileChooser chooser = new JFileChooser();
	public OpenCommand()
	{
		chooser.setFileFilter(new NovaForceImageFilter());
		chooser.setCurrentDirectory(new File(NovaForceImage.config.lastDir));
	}
	@Override
	public void run()
	{
		if(subject == null)
		{
			focus(new BlockImage());
			window.focus(subject);
		}
		if(chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Open it
				subject.open(fname);
				window.repaint();
				NovaForceImage.config.setLastDirFromFile(new File(fname));
				NovaForceImage.config.save();
				window.focus(subject);
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not open "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Open";
	}
}