package nfimage;

import java.io.File;
import java.io.IOException;

import nf.ToolModule;

/**
 * This is the image preparer for the NovaForce engine.
 * It can either be opened all by itself or take in resources.
 * This is necessary since the engine takes its own formats.
 * @author Sayuri
 */
public class NovaForceImage extends ToolModule
{
	public static ImageConfig config = new ImageConfig();
	private ImageWindow imageWindow;
	/**
	 * Automatically converts a filename into an NFI filename.
	 * @param filename The filename to modify
	 * @return The modified filename
	 */
	public static String autoNFI(File f)
	{
		String str = f.getPath();
		// More than 4
		if(str.length() > 4)
		{
			// Cut it out
			str = str.substring(0,str.length()-4);
			str += ".nfi";
		}
		// End
		return str;
	}
	@Override
	public void direct()
	{
		config.load();
		imageWindow = new ImageWindow(true);
		ImageCommand.window(imageWindow);
		imageWindow.open();
	}
	/**
	 * Imports the .bmp file and encodes it as a .nfi file.
	 * @param filename The .bmp image to import
	 * @throws IOException
	 */
	public void importImage(String filename) throws IOException
	{
		// Announce
		System.out.println("Importing BMP: "+filename);
		config.load();
		imageWindow = new ImageWindow(false);
		ImageCommand.window(imageWindow);
		// OK, now force an import
		BlockImage bi = new BlockImage(filename);
		imageWindow.focus(bi);
		ImageCommand.focus(bi);
		imageWindow.setIndirectFile(autoNFI(new File(filename)));
		imageWindow.open();
	}
	@Override
	public void indirect(String filename) throws IOException
	{
		// Announce
		System.out.println("Opening NFI: "+filename);
		config.load();
		imageWindow = new ImageWindow(false);
		ImageCommand.window(imageWindow);
		// OK, now force open a loading
		BlockImage bi = new BlockImage();
		bi.open(filename);
		imageWindow.focus(bi);
		ImageCommand.focus(bi);
		imageWindow.setIndirectFile(filename);
		imageWindow.open();
	}
}