package nfimage;

import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import nf.ErrorBox;

public class ImportCommand extends ImageCommand
{
	private JFileChooser chooser = new JFileChooser();
	public ImportCommand()
	{
		chooser.setFileFilter(new BitmapFileFilter());
		chooser.setCurrentDirectory(new File(NovaForceImage.config.lastDir));
	}
	@Override
	public void run()
	{
		if(chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
		{
			String fname = chooser.getSelectedFile().getPath();
			try
			{
				// Load
				BlockImage bi = new BlockImage(fname);
				// Focus
				focus(bi);
				window.focus(bi);
				NovaForceImage.config.setLastDirFromFile(new File(fname));
				NovaForceImage.config.save();
				// Set auto file
				ImageCommand.setAutoFile(NovaForceImage.autoNFI(new File(fname)));
			}
			catch(IOException e)
			{
				ErrorBox.show("Could not open "+fname+".");
			}
		}
	}
	@Override
	public String toString()
	{
		return "Import";
	}
}