package nfimage;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;

import javax.swing.JDialog;
import javax.swing.JFrame;

import nf.ErrorBox;

/**
 * This is the main window for the image preparer.
 * @author Sayuri
 */
public class ImageWindow extends JFrame
{
	private static final long serialVersionUID = 1L;
	private BlockPanel blockPanel;
	private ImageMenuBar imageMenuBar;
	private TransPanel transPanel;
	private boolean directMode;
	private String indirectFile;
	public void setIndirectFile(String f)
	{
		// Set
		indirectFile = f;
	}
	/**
	 * Handles messages in direct mode.
	 * @author Sayuri
	 */
	private class ImageAdapter extends WindowAdapter
	{
		@Override
		public void windowClosing(WindowEvent e)
		{
			// End program
			close();
		}
		@Override
		public void windowClosed(WindowEvent e)
		{
			// Auto save
			if(!directMode)
			{
				System.out.println("Saved: "+indirectFile);
				try
				{
					blockPanel.getFocus().save(indirectFile);
				}
				catch(IOException ee)
				{
					ErrorBox.show("Failed to save "+indirectFile);
				}
			}
			// Direct?
			if(directMode)
				System.exit(0);
		}
	}
	/**
	 * Create a new image window.
	 * @param direct If true, the editor will open in direct mode
	 */
	public ImageWindow(boolean direct)
	{
		// Title it
		super("Image Converter");
		// Ops
		directMode = direct;
		// Properties
		setLayout(new BorderLayout());
		addWindowListener(new ImageAdapter());
		setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
		// Build
		imageMenuBar = new ImageMenuBar(direct);
		getContentPane().add(imageMenuBar,BorderLayout.NORTH);
		blockPanel = new BlockPanel();
		getContentPane().add(blockPanel,BorderLayout.CENTER);
		transPanel = new TransPanel();
		getContentPane().add(transPanel,BorderLayout.SOUTH);
		pack();
	}
	/**
	 * Open the window.
	 */
	public void open()
	{
		// Center
		setLocationRelativeTo(null);
		// Show
		setVisible(true);
	}
	/**
	 * Closes the window.
	 */
	public void close()
	{
		// Indirect
		dispose();
	}
	/**
	 * Focuses on a new image.
	 * @param bi The block image to focus on
	 */
	public void focus(BlockImage bi)
	{
		// Set
		blockPanel.focus(bi,transPanel);
		// Set transcolor
		transPanel.setColor(bi.getTransparentColor());
	}
}