package nfimage;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class ImageMenuBar extends JMenuBar
{
	private static final long serialVersionUID = 1L;
	private JMenu fileMenu = new JMenu("File");
	private JMenu editMenu = new JMenu("Edit");
	private ExitCommand exitCommand = new ExitCommand();
	private ImportCommand importCommand = new ImportCommand();
	private SaveCommand saveCommand = new SaveCommand();
	private FrameCommand frameCommand = new FrameCommand();
	private OpenCommand openCommand = new OpenCommand();
	public ImageMenuBar(boolean direct)
	{
		// Direct options?
		if(direct)
		{
			fileMenu.add(importCommand.makeMenuItem());
			fileMenu.add(openCommand.makeMenuItem());
			fileMenu.add(saveCommand.makeMenuItem());
			fileMenu.addSeparator();
		}
		// Add items
		fileMenu.add(exitCommand.makeMenuItem());
		editMenu.add(frameCommand.makeMenuItem());
		// Add menus
		add(fileMenu);
		add(editMenu);
	}
}