package nfimage;

import java.awt.image.BufferedImage;

/**
 * An image listener responds to changing images.
 * This is commonly used for display updates on buffered images.
 * @author Sayuri
 */
public interface ImageListener
{
	/**
	 * This method is called whenever the image changes.
	 * @param img The image that has changed
	 */
	public abstract void imageChanged(BufferedImage img);
}